/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.filter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.fortuna.ical4j.filter.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Filter {
    public static final int MATCH_ANY = 1;
    public static final int MATCH_ALL = 2;
    private Log log = LogFactory.getLog((Class)Filter.class);
    private Rule[] rules;
    private int type;

    public Filter(Rule rule) {
        this(new Rule[]{rule}, 1);
    }

    public Filter(Rule[] rules, int type) {
        this.rules = rules;
        this.type = type;
    }

    public final Collection filter(Collection c) {
        if (this.getRules() != null && this.getRules().length > 0) {
            ArrayList<Object> filtered;
            try {
                filtered = (ArrayList<Object>)c.getClass().newInstance();
            }
            catch (Exception e) {
                filtered = new ArrayList<Object>();
            }
            if (this.type == 2) {
                filtered.addAll(this.matchAll(c));
            } else {
                Object match = this.matchAny(c);
                if (match != null) {
                    filtered.add(match);
                }
            }
            return filtered;
        }
        return c;
    }

    private List matchAll(Collection c) {
        ArrayList list = new ArrayList(c);
        ArrayList temp = new ArrayList();
        for (int n = 0; n < this.getRules().length; ++n) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!this.getRules()[n].match(o)) continue;
                temp.add(o);
            }
            list = temp;
            temp = new ArrayList();
        }
        return list;
    }

    private Object matchAny(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            for (int n = 0; n < this.getRules().length; ++n) {
                if (!this.getRules()[n].match(o)) continue;
                return o;
            }
        }
        return null;
    }

    public final Object[] filter(Object[] objects) {
        Collection filtered = this.filter(Arrays.asList(objects));
        try {
            return filtered.toArray((Object[])Array.newInstance(objects.getClass(), filtered.size()));
        }
        catch (ArrayStoreException ase) {
            this.log.warn((Object)"Error converting to array - using default approach", (Throwable)ase);
            return filtered.toArray();
        }
    }

    public final Rule[] getRules() {
        return this.rules;
    }

    public final void setRules(Rule[] rules) {
        this.rules = rules;
    }
}

