/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deque<E> {
    private LinkedList<E> ll = new LinkedList();

    public boolean isEmpty() {
        return this.ll.isEmpty();
    }

    public Object[] toArray() {
        return this.ll.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.ll.toArray(a);
    }

    public boolean containsAll(Collection<?> c) {
        return this.ll.containsAll(c);
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.ll.addAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.ll.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.ll.retainAll(c);
    }

    public void clear() {
        this.ll.clear();
    }

    public void addFirst(E e) {
        this.ll.addFirst(e);
    }

    public void addLast(E e) {
        this.ll.addLast(e);
    }

    public boolean offerFirst(E e) {
        this.ll.addFirst(e);
        return true;
    }

    public boolean offerLast(E e) {
        this.ll.addLast(e);
        return true;
    }

    public E removeFirst() {
        return this.ll.removeFirst();
    }

    public E removeLast() {
        return this.ll.removeLast();
    }

    public E pollFirst() {
        return this.ll.poll();
    }

    public E pollLast() {
        E e;
        try {
            e = this.ll.removeLast();
        }
        catch (NoSuchElementException ex) {
            e = null;
        }
        return e;
    }

    public E getFirst() {
        return this.ll.getFirst();
    }

    public E getLast() {
        return this.ll.getLast();
    }

    public E peekFirst() {
        return this.ll.peek();
    }

    public E peekLast() {
        E e;
        try {
            e = this.ll.getLast();
        }
        catch (NoSuchElementException ex) {
            e = null;
        }
        return e;
    }

    public boolean removeFirstOccurrence(Object o) {
        return this.ll.remove(o);
    }

    public boolean removeLastOccurrence(Object o) {
        ListIterator<E> litr = this.ll.listIterator(this.ll.size());
        while (litr.hasPrevious()) {
            E e = litr.previous();
            if ((o != null || e != null) && (o == null || !o.equals(e))) continue;
            litr.remove();
            return true;
        }
        return false;
    }

    public boolean add(E e) {
        return this.ll.add(e);
    }

    public boolean offer(E e) {
        return this.ll.offer(e);
    }

    public E remove() {
        return this.ll.remove();
    }

    public E poll() {
        return this.ll.poll();
    }

    public E element() {
        return this.ll.element();
    }

    public E peek() {
        return this.ll.peek();
    }

    public void push(E e) {
        this.ll.addFirst(e);
    }

    public E pop() {
        return this.ll.removeFirst();
    }

    public boolean remove(Object o) {
        return this.ll.remove(o);
    }

    public boolean contains(Object o) {
        return this.ll.contains(o);
    }

    public int size() {
        return this.ll.size();
    }

    public Iterator<E> iterator() {
        return this.ll.iterator();
    }

    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescendingIterator
    implements Iterator<E> {
        private ListIterator<E> litr;

        DescendingIterator() {
            this.litr = Deque.this.ll.listIterator(Deque.this.ll.size());
        }

        @Override
        public boolean hasNext() {
            return this.litr.hasPrevious();
        }

        @Override
        public E next() {
            return this.litr.previous();
        }

        @Override
        public void remove() {
            this.litr.remove();
        }
    }
}

