/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.impl;

import com.liferay.ibm.icu.impl.ICUConfig;
import com.liferay.ibm.icu.impl.ICUData;
import com.liferay.ibm.icu.util.ICUUncheckedIOException;
import com.liferay.ibm.icu.util.VersionInfo;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ICUBinary {
    private static final List<DataFile> icuDataFiles = new ArrayList<DataFile>();
    private static final byte MAGIC1 = -38;
    private static final byte MAGIC2 = 39;
    private static final byte CHAR_SET_ = 0;
    private static final byte CHAR_SIZE_ = 2;
    private static final String MAGIC_NUMBER_AUTHENTICATION_FAILED_ = "ICU data file error: Not an ICU data file";
    private static final String HEADER_AUTHENTICATION_FAILED_ = "ICU data file error: Header authentication failed, please check if you have a valid ICU data file";

    private static void addDataFilesFromPath(String dataPath, List<DataFile> files) {
        int pathStart = 0;
        while (pathStart < dataPath.length()) {
            int sepIndex = dataPath.indexOf(File.pathSeparatorChar, pathStart);
            int pathLimit = sepIndex >= 0 ? sepIndex : dataPath.length();
            String path = dataPath.substring(pathStart, pathLimit).trim();
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() != 0) {
                ICUBinary.addDataFilesFromFolder(new File(path), new StringBuilder(), icuDataFiles);
            }
            if (sepIndex < 0) break;
            pathStart = sepIndex + 1;
        }
    }

    private static void addDataFilesFromFolder(File folder, StringBuilder itemPath, List<DataFile> dataFiles) {
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        int folderPathLength = itemPath.length();
        if (folderPathLength > 0) {
            itemPath.append('/');
            ++folderPathLength;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(".txt")) continue;
            itemPath.append(fileName);
            if (file.isDirectory()) {
                ICUBinary.addDataFilesFromFolder(file, itemPath, dataFiles);
            } else if (fileName.endsWith(".dat")) {
                ByteBuffer pkgBytes = ICUBinary.mapFile(file);
                if (pkgBytes != null && DatPackageReader.validate(pkgBytes)) {
                    dataFiles.add(new DataFile(itemPath.toString(), pkgBytes));
                }
            } else {
                dataFiles.add(new DataFile(itemPath.toString(), file));
            }
            itemPath.setLength(folderPathLength);
        }
    }

    static int compareKeys(CharSequence key, ByteBuffer bytes, int offset) {
        int i = 0;
        while (true) {
            byte c2;
            if ((c2 = bytes.get(offset)) == 0) {
                if (i == key.length()) {
                    return 0;
                }
                return 1;
            }
            if (i == key.length()) {
                return -1;
            }
            int diff = key.charAt(i) - c2;
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++offset;
        }
    }

    public static ByteBuffer getData(String itemPath) {
        return ICUBinary.getData(null, null, itemPath, false);
    }

    public static ByteBuffer getData(ClassLoader loader, String resourceName, String itemPath) {
        return ICUBinary.getData(loader, resourceName, itemPath, false);
    }

    public static ByteBuffer getRequiredData(String itemPath) {
        return ICUBinary.getData(null, null, itemPath, true);
    }

    private static ByteBuffer getData(ClassLoader loader, String resourceName, String itemPath, boolean required) {
        InputStream is;
        ByteBuffer bytes = ICUBinary.getDataFromFile(itemPath);
        if (bytes != null) {
            return bytes;
        }
        if (loader == null) {
            loader = ICUData.class.getClassLoader();
        }
        if (resourceName == null) {
            resourceName = "com/liferay/ibm/icu/impl/data/icudt54b/" + itemPath;
        }
        if ((is = ICUData.getStream(loader, resourceName, required)) == null) {
            return null;
        }
        try {
            return ICUBinary.getByteBufferFromInputStream(is);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private static ByteBuffer getDataFromFile(String itemPath) {
        for (DataFile dataFile : icuDataFiles) {
            if (dataFile.pkgBytes != null) {
                ByteBuffer data = DatPackageReader.getData(dataFile.pkgBytes, itemPath);
                if (data == null) continue;
                return data;
            }
            if (!itemPath.equals(dataFile.itemPath)) continue;
            return ICUBinary.mapFile(dataFile.path);
        }
        return null;
    }

    private static ByteBuffer mapFile(File path) {
        try {
            FileInputStream file = new FileInputStream(path);
            FileChannel channel = file.getChannel();
            MappedByteBuffer bytes = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            file.close();
            return bytes;
        }
        catch (FileNotFoundException ignored) {
            System.err.println(ignored);
        }
        catch (IOException ignored) {
            System.err.println(ignored);
        }
        return null;
    }

    public static VersionInfo readHeaderAndDataVersion(ByteBuffer bytes, int dataFormat, Authenticate authenticate) throws IOException {
        return ICUBinary.getVersionInfoFromCompactInt(ICUBinary.readHeader(bytes, dataFormat, authenticate));
    }

    public static int readHeader(ByteBuffer bytes, int dataFormat, Authenticate authenticate) throws IOException {
        assert (bytes.position() == 0);
        byte magic1 = bytes.get(2);
        byte magic2 = bytes.get(3);
        if (magic1 != -38 || magic2 != 39) {
            throw new IOException(MAGIC_NUMBER_AUTHENTICATION_FAILED_);
        }
        byte isBigEndian = bytes.get(8);
        byte charsetFamily = bytes.get(9);
        byte sizeofUChar = bytes.get(10);
        if (isBigEndian < 0 || 1 < isBigEndian || charsetFamily != 0 || sizeofUChar != 2) {
            throw new IOException(HEADER_AUTHENTICATION_FAILED_);
        }
        bytes.order(isBigEndian != 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        char headerSize = bytes.getChar(0);
        char sizeofUDataInfo = bytes.getChar(4);
        if (sizeofUDataInfo < '\u0014' || headerSize < sizeofUDataInfo + 4) {
            throw new IOException("Internal Error: Header size error");
        }
        byte[] formatVersion = new byte[]{bytes.get(16), bytes.get(17), bytes.get(18), bytes.get(19)};
        if (bytes.get(12) != (byte)(dataFormat >> 24) || bytes.get(13) != (byte)(dataFormat >> 16) || bytes.get(14) != (byte)(dataFormat >> 8) || bytes.get(15) != (byte)dataFormat || authenticate != null && !authenticate.isDataVersionAcceptable(formatVersion)) {
            throw new IOException(HEADER_AUTHENTICATION_FAILED_ + String.format("; data format %02x%02x%02x%02x, format version %d.%d.%d.%d", bytes.get(12), bytes.get(13), bytes.get(14), bytes.get(15), formatVersion[0] & 0xFF, formatVersion[1] & 0xFF, formatVersion[2] & 0xFF, formatVersion[3] & 0xFF));
        }
        bytes.position(headerSize);
        return bytes.get(20) << 24 | (bytes.get(21) & 0xFF) << 16 | (bytes.get(22) & 0xFF) << 8 | bytes.get(23) & 0xFF;
    }

    public static int writeHeader(int dataFormat, int formatVersion, int dataVersion, DataOutputStream dos) throws IOException {
        dos.writeChar(32);
        dos.writeByte(-38);
        dos.writeByte(39);
        dos.writeChar(20);
        dos.writeChar(0);
        dos.writeByte(1);
        dos.writeByte(0);
        dos.writeByte(2);
        dos.writeByte(0);
        dos.writeInt(dataFormat);
        dos.writeInt(formatVersion);
        dos.writeInt(dataVersion);
        dos.writeLong(0L);
        assert (dos.size() == 32);
        return 32;
    }

    public static void skipBytes(ByteBuffer bytes, int skipLength) {
        if (skipLength > 0) {
            bytes.position(bytes.position() + skipLength);
        }
    }

    public static ByteBuffer sliceWithOrder(ByteBuffer bytes) {
        ByteBuffer b = bytes.slice();
        return b.order(bytes.order());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer getByteBufferFromInputStream(InputStream is) throws IOException {
        try {
            int avail = is.available();
            byte[] bytes = new byte[avail];
            ICUBinary.readFully(is, bytes, 0, avail);
            while ((avail = is.available()) != 0) {
                byte[] newBytes = new byte[bytes.length + avail];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                ICUBinary.readFully(is, newBytes, bytes.length, avail);
                bytes = newBytes;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            return byteBuffer;
        }
        finally {
            is.close();
        }
    }

    private static void readFully(InputStream is, byte[] bytes, int offset, int avail) throws IOException {
        while (avail > 0) {
            int numRead = is.read(bytes, offset, avail);
            assert (numRead > 0);
            offset += numRead;
            avail -= numRead;
        }
    }

    public static VersionInfo getVersionInfoFromCompactInt(int version) {
        return VersionInfo.getInstance(version >>> 24, version >> 16 & 0xFF, version >> 8 & 0xFF, version & 0xFF);
    }

    public static byte[] getVersionByteArrayFromCompactInt(int version) {
        return new byte[]{(byte)(version >> 24), (byte)(version >> 16), (byte)(version >> 8), (byte)version};
    }

    static {
        String dataPath = ICUConfig.get(ICUBinary.class.getName() + ".dataPath");
        if (dataPath != null) {
            ICUBinary.addDataFilesFromPath(dataPath, icuDataFiles);
        }
    }

    public static interface Authenticate {
        public boolean isDataVersionAcceptable(byte[] var1);
    }

    private static final class DataFile {
        public final String itemPath;
        public final File path;
        public final ByteBuffer pkgBytes;

        public DataFile(String item, File path) {
            this.itemPath = item;
            this.path = path;
            this.pkgBytes = null;
        }

        public DataFile(String item, ByteBuffer bytes) {
            this.itemPath = item;
            this.path = null;
            this.pkgBytes = bytes;
        }

        public String toString() {
            return this.path.toString();
        }
    }

    private static final class DatPackageReader {
        private static final int DATA_FORMAT = 1131245124;
        private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();

        private DatPackageReader() {
        }

        private static boolean validate(ByteBuffer bytes) {
            try {
                ICUBinary.readHeader(bytes, 1131245124, IS_ACCEPTABLE);
            }
            catch (IOException ignored) {
                return false;
            }
            int count = bytes.getInt(bytes.position());
            if (count <= 0) {
                return false;
            }
            if (bytes.position() + 4 + count * 24 > bytes.capacity()) {
                return false;
            }
            return DatPackageReader.startsWithPackageName(bytes, DatPackageReader.getNameOffset(bytes, 0)) && DatPackageReader.startsWithPackageName(bytes, DatPackageReader.getNameOffset(bytes, count - 1));
        }

        private static boolean startsWithPackageName(ByteBuffer bytes, int start) {
            byte c;
            int length = "icudt54b".length() - 1;
            for (int i = 0; i < length; ++i) {
                if (bytes.get(start + i) == "icudt54b".charAt(i)) continue;
                return false;
            }
            return ((c = bytes.get(start + length++)) == 98 || c == 108) && bytes.get(start + length) == 47;
        }

        private static ByteBuffer getData(ByteBuffer bytes, CharSequence key) {
            int base = bytes.position();
            int count = bytes.getInt(base);
            int start = 0;
            int limit = count;
            while (start < limit) {
                int mid = start + limit >>> 1;
                int nameOffset = DatPackageReader.getNameOffset(bytes, mid);
                int result = ICUBinary.compareKeys(key, bytes, nameOffset += "icudt54b".length() + 1);
                if (result < 0) {
                    limit = mid;
                    continue;
                }
                if (result > 0) {
                    start = mid + 1;
                    continue;
                }
                ByteBuffer data = bytes.duplicate();
                data.position(DatPackageReader.getDataOffset(bytes, mid));
                data.limit(DatPackageReader.getDataOffset(bytes, mid + 1));
                return ICUBinary.sliceWithOrder(data);
            }
            return null;
        }

        private static int getNameOffset(ByteBuffer bytes, int index) {
            int base = bytes.position();
            assert (0 <= index && index < bytes.getInt(base));
            return base + bytes.getInt(base + 4 + index * 8);
        }

        private static int getDataOffset(ByteBuffer bytes, int index) {
            int base = bytes.position();
            int count = bytes.getInt(base);
            if (index == count) {
                return bytes.capacity();
            }
            assert (0 <= index && index < count);
            return base + bytes.getInt(base + 4 + 4 + index * 8);
        }

        private static final class IsAcceptable
        implements Authenticate {
            private IsAcceptable() {
            }

            public boolean isDataVersionAcceptable(byte[] version) {
                return version[0] == 1;
            }
        }
    }
}

