/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.impl.coll;

import com.liferay.ibm.icu.impl.coll.SharedObject;
import java.util.Arrays;

public final class CollationSettings
extends SharedObject {
    public static final int CHECK_FCD = 1;
    public static final int NUMERIC = 2;
    static final int SHIFTED = 4;
    static final int ALTERNATE_MASK = 12;
    static final int MAX_VARIABLE_SHIFT = 4;
    static final int MAX_VARIABLE_MASK = 112;
    static final int UPPER_FIRST = 256;
    public static final int CASE_FIRST = 512;
    public static final int CASE_FIRST_AND_UPPER_MASK = 768;
    public static final int CASE_LEVEL = 1024;
    public static final int BACKWARD_SECONDARY = 2048;
    static final int STRENGTH_SHIFT = 12;
    static final int STRENGTH_MASK = 61440;
    static final int MAX_VAR_SPACE = 0;
    static final int MAX_VAR_PUNCT = 1;
    static final int MAX_VAR_SYMBOL = 2;
    static final int MAX_VAR_CURRENCY = 3;
    public int options = 8208;
    public long variableTop;
    public byte[] reorderTable;
    public int[] reorderCodes = EMPTY_INT_ARRAY;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public int fastLatinOptions = -1;
    public char[] fastLatinPrimaries = new char[384];

    CollationSettings() {
    }

    public CollationSettings clone() {
        CollationSettings newSettings = (CollationSettings)super.clone();
        newSettings.fastLatinPrimaries = (char[])this.fastLatinPrimaries.clone();
        return newSettings;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        CollationSettings o = (CollationSettings)other;
        if (this.options != o.options) {
            return false;
        }
        if ((this.options & 0xC) != 0 && this.variableTop != o.variableTop) {
            return false;
        }
        return Arrays.equals(this.reorderCodes, o.reorderCodes);
    }

    public int hashCode() {
        int h = this.options << 8;
        if ((this.options & 0xC) != 0) {
            h = (int)((long)h ^ this.variableTop);
        }
        h ^= this.reorderCodes.length;
        for (int i = 0; i < this.reorderCodes.length; ++i) {
            h ^= this.reorderCodes[i] << i;
        }
        return h;
    }

    public void resetReordering() {
        this.reorderTable = null;
        this.reorderCodes = EMPTY_INT_ARRAY;
    }

    public void setReordering(int[] codes, byte[] table) {
        if (codes == null) {
            codes = EMPTY_INT_ARRAY;
        }
        assert (codes.length == 0 == (table == null));
        this.reorderTable = table;
        this.reorderCodes = codes;
    }

    public void setStrength(int value) {
        int noStrength = this.options & 0xFFFF0FFF;
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 15: {
                this.options = noStrength | value << 12;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal strength value " + value);
            }
        }
    }

    public void setStrengthDefault(int defaultOptions) {
        int noStrength = this.options & 0xFFFF0FFF;
        this.options = noStrength | defaultOptions & 0xF000;
    }

    static int getStrength(int options) {
        return options >> 12;
    }

    public int getStrength() {
        return CollationSettings.getStrength(this.options);
    }

    public void setFlag(int bit, boolean value) {
        this.options = value ? (this.options |= bit) : (this.options &= ~bit);
    }

    public void setFlagDefault(int bit, int defaultOptions) {
        this.options = this.options & ~bit | defaultOptions & bit;
    }

    public boolean getFlag(int bit) {
        return (this.options & bit) != 0;
    }

    public void setCaseFirst(int value) {
        assert (value == 0 || value == 512 || value == 768);
        int noCaseFirst = this.options & 0xFFFFFCFF;
        this.options = noCaseFirst | value;
    }

    public void setCaseFirstDefault(int defaultOptions) {
        int noCaseFirst = this.options & 0xFFFFFCFF;
        this.options = noCaseFirst | defaultOptions & 0x300;
    }

    public int getCaseFirst() {
        return this.options & 0x300;
    }

    public void setAlternateHandlingShifted(boolean value) {
        int noAlternate = this.options & 0xFFFFFFF3;
        this.options = value ? noAlternate | 4 : noAlternate;
    }

    public void setAlternateHandlingDefault(int defaultOptions) {
        int noAlternate = this.options & 0xFFFFFFF3;
        this.options = noAlternate | defaultOptions & 0xC;
    }

    public boolean getAlternateHandling() {
        return (this.options & 0xC) != 0;
    }

    public void setMaxVariable(int value, int defaultOptions) {
        int noMax = this.options & 0xFFFFFF8F;
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.options = noMax | value << 4;
                break;
            }
            case -1: {
                this.options = noMax | defaultOptions & 0x70;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal maxVariable value " + value);
            }
        }
    }

    public int getMaxVariable() {
        return (this.options & 0x70) >> 4;
    }

    static boolean isTertiaryWithCaseBits(int options) {
        return (options & 0x600) == 512;
    }

    static int getTertiaryMask(int options) {
        return CollationSettings.isTertiaryWithCaseBits(options) ? 65343 : 16191;
    }

    static boolean sortsTertiaryUpperCaseFirst(int options) {
        return (options & 0x700) == 768;
    }

    public boolean dontCheckFCD() {
        return (this.options & 1) == 0;
    }

    boolean hasBackwardSecondary() {
        return (this.options & 0x800) != 0;
    }

    public boolean isNumeric() {
        return (this.options & 2) != 0;
    }
}

