/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder;

import org.scribe.builder.api.Api;
import org.scribe.exceptions.OAuthException;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.Preconditions;

public class ServiceBuilder {
    private String apiKey;
    private String apiSecret;
    private String callback = "oob";
    private Api api;
    private String scope;

    public ServiceBuilder provider(Class<? extends Api> apiClass) {
        this.api = this.createApi(apiClass);
        return this;
    }

    private Api createApi(Class<? extends Api> apiClass) {
        Api api;
        Preconditions.checkNotNull(apiClass, "Api class cannot be null");
        try {
            api = apiClass.newInstance();
        }
        catch (Exception e) {
            throw new OAuthException("Error while creating the Api object", e);
        }
        return api;
    }

    public ServiceBuilder callback(String callback) {
        Preconditions.checkValidOAuthCallback(callback, "Callback must be a valid URL or 'oob'");
        this.callback = callback;
        return this;
    }

    public ServiceBuilder apiKey(String apiKey) {
        Preconditions.checkEmptyString(apiKey, "Invalid Api key");
        this.apiKey = apiKey;
        return this;
    }

    public ServiceBuilder apiSecret(String apiSecret) {
        Preconditions.checkEmptyString(apiSecret, "Invalid Api secret");
        this.apiSecret = apiSecret;
        return this;
    }

    public ServiceBuilder scope(String scope) {
        Preconditions.checkEmptyString(scope, "Invalid OAuth scope");
        this.scope = scope;
        return this;
    }

    public OAuthService build() {
        Preconditions.checkNotNull(this.api, "You must specify a valid api through the provider() method");
        Preconditions.checkEmptyString(this.apiKey, "You must provide an api key");
        Preconditions.checkEmptyString(this.apiSecret, "You must provide an api secret");
        return this.api.createService(this.apiKey, this.apiSecret, this.callback, this.scope);
    }
}

