/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.Api;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.BaseStringExtractor;
import org.scribe.extractors.BaseStringExtractorImpl;
import org.scribe.extractors.HeaderExtractor;
import org.scribe.extractors.HeaderExtractorImpl;
import org.scribe.extractors.RequestTokenExtractor;
import org.scribe.extractors.TokenExtractorImpl;
import org.scribe.model.OAuthConfig;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuth10aServiceImpl;
import org.scribe.oauth.OAuthService;
import org.scribe.services.HMACSha1SignatureService;
import org.scribe.services.SignatureService;
import org.scribe.services.TimestampService;
import org.scribe.services.TimestampServiceImpl;

public abstract class DefaultApi10a
implements Api {
    protected AccessTokenExtractor getAccessTokenExtractor() {
        return new TokenExtractorImpl();
    }

    protected BaseStringExtractor getBaseStringExtractor() {
        return new BaseStringExtractorImpl();
    }

    protected HeaderExtractor getHeaderExtractor() {
        return new HeaderExtractorImpl();
    }

    protected RequestTokenExtractor getRequestTokenExtractor() {
        return new TokenExtractorImpl();
    }

    protected SignatureService getSignatureService() {
        return new HMACSha1SignatureService();
    }

    protected TimestampService getTimestampService() {
        return new TimestampServiceImpl();
    }

    protected Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    protected Verb getRequestTokenVerb() {
        return Verb.POST;
    }

    protected abstract String getRequestTokenEndpoint();

    protected abstract String getAccessTokenEndpoint();

    @Override
    public OAuthService createService(String apiKey, String apiSecret, String callback, String scope) {
        OAuthService service = this.createService(apiKey, apiSecret, callback);
        service.addScope(scope);
        return service;
    }

    private OAuthService createService(String apiKey, String apiSecret, String callback) {
        return new OAuth10aServiceImpl(this.getSignatureService(), this.getTimestampService(), this.getBaseStringExtractor(), this.getHeaderExtractor(), this.getRequestTokenExtractor(), this.getAccessTokenExtractor(), this.createConfig(apiKey, apiSecret, callback));
    }

    private OAuthConfig createConfig(String apiKey, String apiSecret, String callback) {
        OAuthConfig config = new OAuthConfig();
        config.setRequestTokenVerb(this.getRequestTokenVerb());
        config.setRequestTokenEndpoint(this.getRequestTokenEndpoint());
        config.setAccessTokenVerb(this.getAccessTokenVerb());
        config.setAccessTokenEndpoint(this.getAccessTokenEndpoint());
        config.setApiKey(apiKey);
        config.setApiSecret(apiSecret);
        config.setCallback(callback);
        return config;
    }
}

