/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.oauth;

import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.BaseStringExtractor;
import org.scribe.extractors.HeaderExtractor;
import org.scribe.extractors.RequestTokenExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthConstants;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.scribe.services.SignatureService;
import org.scribe.services.TimestampService;

public class OAuth10aServiceImpl
implements OAuthService {
    private static final String NO_SCOPE = null;
    private static final String VERSION = "1.0";
    private OAuthConfig config;
    private SignatureService signatureService;
    private TimestampService timestampService;
    private BaseStringExtractor baseStringExtractor;
    private HeaderExtractor headerExtractor;
    private RequestTokenExtractor rtExtractor;
    private AccessTokenExtractor atExtractor;
    private String scope;

    public OAuth10aServiceImpl(SignatureService signatureService, TimestampService timestampService, BaseStringExtractor baseStringExtractor, HeaderExtractor headerExtractor, RequestTokenExtractor rtExtractor, AccessTokenExtractor atExtractor, OAuthConfig config) {
        this.signatureService = signatureService;
        this.timestampService = timestampService;
        this.baseStringExtractor = baseStringExtractor;
        this.headerExtractor = headerExtractor;
        this.rtExtractor = rtExtractor;
        this.atExtractor = atExtractor;
        this.config = config;
        this.scope = NO_SCOPE;
    }

    @Override
    public Token getRequestToken() {
        OAuthRequest request = new OAuthRequest(this.config.getRequestTokenVerb(), this.config.getRequestTokenEndpoint());
        this.addOAuthParams(request, OAuthConstants.EMPTY_TOKEN);
        this.addOAuthHeader(request);
        Response response = request.send();
        return this.rtExtractor.extract(response.getBody());
    }

    private void addOAuthParams(OAuthRequest request, Token token) {
        request.addOAuthParameter("oauth_timestamp", this.timestampService.getTimestampInSeconds());
        request.addOAuthParameter("oauth_nonce", this.timestampService.getNonce());
        request.addOAuthParameter("oauth_consumer_key", this.config.getApiKey());
        request.addOAuthParameter("oauth_signature_method", this.signatureService.getSignatureMethod());
        request.addOAuthParameter("oauth_version", this.getVersion());
        request.addOAuthParameter("oauth_callback", this.config.getCallback());
        if (this.scope != NO_SCOPE) {
            request.addOAuthParameter("scope", this.scope);
        }
        request.addOAuthParameter("oauth_signature", this.getSignature(request, token));
    }

    @Override
    public Token getAccessToken(Token requestToken, Verifier verifier) {
        OAuthRequest request = new OAuthRequest(this.config.getAccessTokenVerb(), this.config.getAccessTokenEndpoint());
        request.addOAuthParameter("oauth_token", requestToken.getToken());
        request.addOAuthParameter("oauth_verifier", verifier.getValue());
        this.addOAuthParams(request, requestToken);
        this.addOAuthHeader(request);
        Response response = request.send();
        return this.atExtractor.extract(response.getBody());
    }

    @Override
    public void signRequest(Token token, OAuthRequest request) {
        request.addOAuthParameter("oauth_token", token.getToken());
        this.addOAuthParams(request, token);
        this.addOAuthHeader(request);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void addScope(String scope) {
        this.scope = scope;
    }

    private String getSignature(OAuthRequest request, Token token) {
        String baseString = this.baseStringExtractor.extract(request);
        return this.signatureService.getSignature(baseString, this.config.getApiSecret(), token.getSecret());
    }

    private void addOAuthHeader(OAuthRequest request) {
        String oauthHeader = this.headerExtractor.extract(request);
        request.addHeader("Authorization", oauthHeader);
    }
}

