/*
 * Decompiled with CFR 0.152.
 */
package ncar.common;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import ncar.common.InvalidRequestException;
import ncar.common.PortletLabel;
import ncar.common.SendRequest;
import ncar.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletService {
    private static final Logger log = LoggerFactory.getLogger(PortletService.class);
    private final List<PortletLabel> periodLabels = new ArrayList<PortletLabel>();
    private final List<PortletLabel> statLabels = new ArrayList<PortletLabel>();
    private final List<PortletLabel> modelLabels = new ArrayList<PortletLabel>();
    private final List<PortletLabel> rcpLabels = new ArrayList<PortletLabel>();
    private final List<String> groups = new ArrayList<String>();
    private String managerUrl;
    protected static final String LIFERAY_HOME = PropsUtil.get((String)"liferay.home");
    private static final String JSON = ".json";
    private final List<PortletLabel> variablesLabels = new ArrayList<PortletLabel>();

    public PortletService() {
        this.initPortalProperties();
        try {
            String jsonStr = new String(Files.readAllBytes(Paths.get(LIFERAY_HOME + "/portalConfig/labels.json", new String[0])));
            JSONArray labelsJson = JSONFactoryUtil.createJSONArray((String)jsonStr);
            for (int i = 0; i < labelsJson.length(); ++i) {
                List<Object> labels = new ArrayList();
                if (labelsJson.getJSONObject(i).getString("id").equals("variables")) {
                    labels = this.variablesLabels;
                } else if (labelsJson.getJSONObject(i).getString("id").equals("period")) {
                    labels = this.periodLabels;
                } else if (labelsJson.getJSONObject(i).getString("id").equals("statistic")) {
                    labels = this.statLabels;
                } else if (labelsJson.getJSONObject(i).getString("id").equals("model")) {
                    labels = this.modelLabels;
                } else if (labelsJson.getJSONObject(i).getString("id").equals("rcp")) {
                    labels = this.rcpLabels;
                }
                JSONArray labelsJsonAr = labelsJson.getJSONObject(i).getJSONArray("labels");
                for (int j = 0; j < labelsJsonAr.length(); ++j) {
                    JSONObject labelsJsonObj = labelsJsonAr.getJSONObject(j);
                    PortletLabel label = this.createLabel(labelsJsonObj);
                    labels.add(label);
                }
            }
        }
        catch (IOException e) {
            log.info(e.toString());
            log.error(String.format("Can't read file %s /portalConfig/labels.json", LIFERAY_HOME));
        }
        catch (JSONException e) {
            log.debug(e.toString());
            log.error(String.format("File %s /portalConfig/labels.json is not proper JSON file", LIFERAY_HOME));
        }
    }

    private PortletLabel createLabel(JSONObject labelsJsonObj) {
        JSONArray groupsJson;
        int[] range;
        JSONArray rangeJson;
        PortletLabel label = new PortletLabel();
        label.setId(labelsJsonObj.getString("id"));
        label.setLabel(labelsJsonObj.getString("label"));
        label.setInfo(labelsJsonObj.getString("info"));
        if (!labelsJsonObj.isNull("palette")) {
            label.setPallet(labelsJsonObj.getString("palette"));
        }
        if (!labelsJsonObj.isNull("unit")) {
            label.setUnit(labelsJsonObj.getString("unit"));
        }
        if (!labelsJsonObj.isNull("range_annual")) {
            try {
                rangeJson = labelsJsonObj.getJSONArray("range_annual");
                range = new int[]{rangeJson.getInt(0), rangeJson.getInt(1)};
                label.setRangeAnnual(range);
            }
            catch (Exception e) {
                log.error(String.format("Can't initialise range_annual for %s. Set to default", label.getId()));
            }
        }
        if (!labelsJsonObj.isNull("range_month")) {
            try {
                rangeJson = labelsJsonObj.getJSONArray("range_month");
                range = new int[]{rangeJson.getInt(0), rangeJson.getInt(1)};
                label.setRangeMonth(range);
            }
            catch (Exception e) {
                log.error(String.format("Can't initialise range_month for %s. Set to default", label.getId()));
            }
        }
        if ((groupsJson = labelsJsonObj.getJSONArray("group")) != null) {
            for (int k = 0; k < groupsJson.length(); ++k) {
                label.setGroup(groupsJson.getString(k));
                if (this.groups.contains(groupsJson.getString(k))) continue;
                this.groups.add(groupsJson.getString(k));
            }
        }
        return label;
    }

    public String getManagerUrl() {
        return this.managerUrl;
    }

    protected void initPortalProperties() {
        try {
            String jsonStr = new String(Files.readAllBytes(Paths.get(LIFERAY_HOME + "/portalConfig/portal.json", new String[0])));
            JSONObject projectJson = JSONFactoryUtil.createJSONObject((String)jsonStr);
            this.managerUrl = projectJson.getString("managerUrl");
        }
        catch (IOException e) {
            log.info(e.toString());
            log.error(String.format("Can't read file %s /portalConfig/portal.json", LIFERAY_HOME));
        }
        catch (JSONException e) {
            log.debug(e.toString());
            log.error(String.format("File %s /portalConfig/portal.json is not proper JSON file", LIFERAY_HOME));
        }
    }

    private JSONArray getAllVariables() {
        JSONArray result = JSONFactoryUtil.createJSONArray();
        HashMap groupToLabel = new HashMap();
        for (PortletLabel portletLabel : this.variablesLabels) {
            for (String group : portletLabel.getGroups()) {
                if (!groupToLabel.containsKey(group)) {
                    groupToLabel.put(group, new ArrayList());
                }
                ((List)groupToLabel.get(group)).add(portletLabel);
            }
        }
        for (Map.Entry entry : groupToLabel.entrySet()) {
            String group;
            JSONObject item = JSONFactoryUtil.createJSONObject();
            item.put("value", (String)entry.getKey());
            item.put("label", (String)entry.getKey());
            item.put("selected", false);
            group = JSONFactoryUtil.createJSONObject();
            group.put("item", item);
            JSONArray children = JSONFactoryUtil.createJSONArray();
            for (PortletLabel label : (List)entry.getValue()) {
                JSONObject childItem = JSONFactoryUtil.createJSONObject();
                childItem.put("value", label.getId());
                childItem.put("label", label.getLabel());
                childItem.put("info", label.getInfo());
                childItem.put("selected", false);
                JSONObject childItemMain = JSONFactoryUtil.createJSONObject();
                childItemMain.put("item", childItem);
                children.put(childItemMain);
            }
            group.put("children", children);
            result.put((JSONObject)group);
        }
        return result;
    }

    private String[] defaultVariables() {
        ArrayList<String> result = new ArrayList<String>(this.variablesLabels.size());
        for (PortletLabel label : this.variablesLabels) {
            result.add(label.getId());
        }
        return result.toArray(new String[result.size()]);
    }

    private List<String> getGroups() {
        return this.groups;
    }

    private List<PortletLabel> getVariablesLabels() {
        return this.variablesLabels;
    }

    protected List<PortletLabel> getPeriodLabels() {
        return this.periodLabels;
    }

    protected List<PortletLabel> getStatLabels() {
        return this.statLabels;
    }

    protected List<PortletLabel> getModelLabels() {
        return this.modelLabels;
    }

    protected List<PortletLabel> getRcpLabels() {
        return this.rcpLabels;
    }

    public JSONObject createVariableLabels(PortletPreferences prefs) {
        JSONObject objectResult = JSONFactoryUtil.createJSONObject();
        List<PortletLabel> labelList = this.getVariablesLabels();
        String defaultVariableValue = prefs.getValue("defaultVariableValue", "");
        for (String group : this.getGroups()) {
            List<String> vars = Arrays.asList(prefs.getValues(group, new String[0]));
            if (vars.isEmpty()) continue;
            JSONArray varsArray = JSONFactoryUtil.createJSONArray();
            for (PortletLabel label : labelList) {
                if (!vars.contains(label.getId())) continue;
                JSONObject naObj = JSONFactoryUtil.createJSONObject();
                naObj.put("label", label.getLabel());
                naObj.put("value", label.getId());
                naObj.put("palette", label.getPallet());
                if (label.getRangeAnnual() != null) {
                    naObj.put("max_annual", label.getRangeAnnual()[1]);
                    naObj.put("min_annual", label.getRangeAnnual()[0]);
                }
                if (label.getRangeMonth() != null) {
                    naObj.put("min_month", label.getRangeMonth()[0]);
                    naObj.put("max_month", label.getRangeMonth()[1]);
                }
                if (label.getUnit() != null) {
                    naObj.put("unit", label.getUnit());
                }
                if (label.getId().equals(defaultVariableValue)) {
                    naObj.put("selected", true);
                } else {
                    naObj.put("selected", false);
                }
                naObj.put("info", label.getInfo());
                varsArray.put(naObj);
            }
            objectResult.put(group, varsArray);
        }
        if (objectResult.length() == 0) {
            JSONArray naArray = JSONFactoryUtil.createJSONArray();
            this.addEmptyObject(naArray);
            objectResult.put("N/A", naArray);
        }
        return objectResult;
    }

    public void addEmptyObject(JSONArray jsonArray) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("label", "N/A");
        jsonObject.put("value", "N/A");
        jsonObject.put("selected", true);
        jsonObject.put("info", "");
        jsonObject.put("palette", "boxfill/rainbow");
        jsonArray.put(jsonObject);
    }

    protected JSONArray getJsonArray(String selectedItem, String jsonResponse) {
        JSONArray result = JSONFactoryUtil.createJSONArray();
        try {
            JSONArray models = JSONFactoryUtil.createJSONArray((String)jsonResponse);
            for (int i = 0; i < models.length(); ++i) {
                this.addJsonObjectToArray(models.getString(i), selectedItem, result);
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage());
        }
        return result;
    }

    public JSONArray getRcp(JSONObject jsonRequest, String selectedItem) {
        String jsonResponse = SendRequest.sendPostWithJson(this.getManagerUrl() + "/getRcp", jsonRequest.toJSONString());
        JSONArray result = this.getJsonArray(selectedItem, jsonResponse);
        if (result.length() == 0) {
            log.error("rcp is null");
        }
        block0: for (int i = 0; i < result.length(); ++i) {
            for (PortletLabel portletLabel : this.getRcpLabels()) {
                if (!portletLabel.getId().equals(result.getJSONObject(i).getString("value"))) continue;
                result.getJSONObject(i).put("label", portletLabel.getLabel());
                result.getJSONObject(i).put("info", portletLabel.getInfo());
                continue block0;
            }
        }
        return result;
    }

    private void addJsonObjectToArray(String value, String selectedItem, JSONArray source) {
        PortletService.addJsonObjectToArray(value, selectedItem, source, null);
    }

    protected static void addJsonObjectToArray(String value, String selectedItem, JSONArray source, List<PortletLabel> labels) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        String label = value;
        String info = "";
        PortletLabel labelObj = null;
        if (labels != null) {
            for (PortletLabel lab : labels) {
                if (!lab.getId().equals(value)) continue;
                labelObj = lab;
                break;
            }
        }
        if (labelObj != null) {
            label = labelObj.getLabel();
            info = labelObj.getInfo();
        }
        jsonObject.put("label", label);
        jsonObject.put("value", value);
        jsonObject.put("info", info);
        if (value.equals(selectedItem)) {
            jsonObject.put("selected", true);
        } else {
            jsonObject.put("selected", false);
        }
        source.put(jsonObject);
    }

    public JSONObject prepareVariables(PortletPreferences prefs) {
        JSONObject result = JSONFactoryUtil.createJSONObject();
        JSONArray variables = this.getAllVariables();
        String defaultVariableLabel = "";
        String defaultVariablesValue = prefs.getValue("defaultVariableValue", "");
        for (int i = 0; i < variables.length(); ++i) {
            JSONArray children = variables.getJSONObject(i).getJSONArray("children");
            String group = variables.getJSONObject(i).getJSONObject("item").getString("label");
            List<String> selectedVariables = Arrays.asList(prefs.getValues(group, new String[0]));
            if (children != null) {
                for (int j = 0; j < children.length(); ++j) {
                    JSONObject item = children.getJSONObject(j).getJSONObject("item");
                    if (selectedVariables.contains(item.getString("value"))) {
                        item.put("selected", true);
                    } else {
                        item.put("selected", false);
                    }
                    if (defaultVariableLabel.isEmpty() && defaultVariablesValue.equals(item.getString("value"))) {
                        item.put("default", true);
                        defaultVariableLabel = item.getString("label");
                        continue;
                    }
                    item.put("default", false);
                }
                continue;
            }
            JSONObject item = variables.getJSONObject(i).getJSONObject("item");
            if (selectedVariables.contains(item.getString("value"))) {
                item.put("selected", true);
            } else {
                item.put("selected", false);
            }
            if (defaultVariableLabel.isEmpty() && defaultVariablesValue.equals(item.getString("value"))) {
                item.put("default", true);
                defaultVariableLabel = item.getString("label");
                continue;
            }
            item.put("default", false);
        }
        result.put("variables", variables);
        result.put("defaultVariableLabel", defaultVariableLabel);
        return result;
    }

    public void storeVariables(ActionRequest actionRequest, PortletPreferences prefs) throws InvalidRequestException {
        String selectedVariablesStr = ParamUtil.get((PortletRequest)actionRequest, (String)"variables", (String)"");
        String[] selectedVariablesFromRequest = selectedVariablesStr.split(",");
        String[] defaultVariables = this.defaultVariables();
        String defaultVariableValue = ParamUtil.get((PortletRequest)actionRequest, (String)"default", (String)"");
        ArrayList<String> selectedVariables = new ArrayList<String>();
        String group = null;
        for (String gr : this.getGroups()) {
            try {
                prefs.reset(gr);
            }
            catch (ReadOnlyException e) {
                log.error(String.format("Can't reset group %s", gr));
            }
        }
        for (String selected : selectedVariablesFromRequest) {
            if (!Arrays.asList(defaultVariables).contains(selected)) {
                String selected1 = selected.replaceAll("\\+", "").replaceAll("\\s", "").replaceAll(":", "");
                Util.verifyParameter(selected1);
                if (group != null) {
                    try {
                        prefs.setValues(group, selectedVariables.toArray(new String[selectedVariables.size()]));
                    }
                    catch (ReadOnlyException e) {
                        log.error(String.format("Can't store variables for group %s", group));
                    }
                }
                group = selected;
                selectedVariables = new ArrayList();
                continue;
            }
            selectedVariables.add(selected);
        }
        if (group != null) {
            try {
                prefs.setValues(group, selectedVariables.toArray(new String[selectedVariables.size()]));
            }
            catch (ReadOnlyException e) {
                log.error(String.format("Can't store variables for group %s", group));
            }
        }
        try {
            prefs.setValues("selectedVariables", selectedVariables.toArray(new String[selectedVariables.size()]));
        }
        catch (ReadOnlyException e) {
            log.error(String.format("Can't store %s", "selectedVariables"));
        }
        try {
            prefs.setValue("defaultVariableValue", defaultVariableValue);
        }
        catch (ReadOnlyException e) {
            log.error(String.format("Can't store %s %s", "defaultVariableValue", defaultVariableValue));
        }
        String narrative = ParamUtil.get((PortletRequest)actionRequest, (String)"narrative", (String)"");
        try {
            prefs.setValue("selectedNarrative", narrative);
        }
        catch (ReadOnlyException e) {
            log.error(e.getMessage());
        }
        try {
            prefs.store();
        }
        catch (IOException | ValidatorException e) {
            log.error(String.format("Can't store preferences %s", e.getMessage()));
        }
    }

    public JSONArray getAvailableFiles() {
        File configDir = new File(LIFERAY_HOME + "/portalConfig/narratives/");
        if (!(configDir.exists() && configDir.isDirectory() && configDir.canRead())) {
            log.error(String.format("Can't read narrative config directory: %s", configDir.getAbsolutePath()));
            return JSONFactoryUtil.createJSONArray();
        }
        String[] narrativeFiles = configDir.list(new JsonFileFilter());
        JSONArray result = JSONFactoryUtil.createJSONArray();
        for (String file : narrativeFiles) {
            result.put(file.replaceAll(JSON, ""));
        }
        result.put("None");
        return result;
    }

    public JSONObject getNarrativeJson(String selectedNarrative) {
        JSONObject result = null;
        if (!selectedNarrative.isEmpty() && !selectedNarrative.equals("None")) {
            try {
                String jsonStr = new String(Files.readAllBytes(Paths.get(LIFERAY_HOME + "/portalConfig/narratives/" + selectedNarrative + JSON, new String[0])));
                result = JSONFactoryUtil.createJSONObject((String)jsonStr);
            }
            catch (IOException e) {
                log.error("Can't read narrative file " + LIFERAY_HOME + "/portalConfig/narratives/" + selectedNarrative + JSON);
            }
            catch (JSONException e) {
                log.error(String.format("JSON file %s %s %s.json is invalid", LIFERAY_HOME, "/portalConfig/narratives/", selectedNarrative));
            }
        }
        if (result == null) {
            result = JSONFactoryUtil.createJSONObject();
        }
        return result;
    }

    private class JsonFileFilter
    implements FilenameFilter {
        private JsonFileFilter() {
        }

        @Override
        public boolean accept(File directory, String fileName) {
            return fileName.endsWith(PortletService.JSON);
        }
    }
}

