/*
 * Decompiled with CFR 0.152.
 */
package ncar.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendRequest {
    private static final Logger log = LoggerFactory.getLogger(SendRequest.class);

    private SendRequest() {
        throw new IllegalStateException("Send requests Utility class");
    }

    public static String sendPost(String url) {
        return SendRequest.sendPostRequest(url, null, null);
    }

    public static String sendGet(String url) {
        return SendRequest.sendGetRequest(url, "");
    }

    public static String sendGet(String url, String lineSeparator) {
        return SendRequest.sendGetRequest(url, lineSeparator);
    }

    public static String sendPostWithParam(String url, String param) {
        return SendRequest.sendPostRequest(url, param, null);
    }

    public static String sendPostWithJson(String url, String jsonStr) {
        return SendRequest.sendPostRequest(url, jsonStr, "application/json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendPostRequest(String url, String requestStr, String mediaType) {
        String result = "";
        HttpURLConnection con = SendRequest.createConnection(url, "POST");
        if (con != null) {
            if (mediaType != null) {
                con.setRequestProperty("Content-Type", mediaType);
            }
            try (OutputStreamWriter os = new OutputStreamWriter(con.getOutputStream());){
                if (requestStr != null) {
                    os.write(requestStr);
                }
                os.flush();
                result = SendRequest.getResponse(con, "");
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            finally {
                con.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendGetRequest(String url, String lineSeparator) {
        String result = "";
        HttpURLConnection con = SendRequest.createConnection(url, "GET");
        if (con != null) {
            try {
                result = SendRequest.getResponse(con, lineSeparator);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            finally {
                con.disconnect();
            }
        }
        return result;
    }

    private static HttpURLConnection createConnection(String url, String requestMethod) {
        HttpURLConnection con = null;
        try {
            URL obj = new URL(url);
            con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod(requestMethod);
            con.setDoOutput(true);
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return con;
    }

    private static String getResponse(HttpURLConnection connection, String lineSeparator) throws IOException {
        StringBuilder result;
        block38: {
            result = new StringBuilder();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                try (InputStream inputStream = connection.getInputStream();
                     InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                     BufferedReader in = new BufferedReader(inputStreamReader);){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        result.append(inputLine);
                        result.append(lineSeparator);
                    }
                    break block38;
                }
            }
            log.error("{} Response Code : {}", (Object)connection.getRequestMethod(), (Object)responseCode);
            log.error("URL: {} ", (Object)connection.getURL());
        }
        return result.toString();
    }
}

