/*
 * Decompiled with CFR 0.152.
 */
package ncar.manager.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Properties;
import ncar.manager.config.WebConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Configuration
@ComponentScan(basePackages={"ncar.manager"})
@Import(value={WebConfig.class})
public class AppConfig {
    @Bean(name={"jacksonObjectMapper"})
    public ObjectMapper jacksonObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.enable(DeserializationFeature.WRAP_EXCEPTIONS);
        return new ObjectMapper();
    }

    @Bean(name={"requestMappingHandlerMapping"})
    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        RequestMappingHandlerMapping requestMappingHandlerMapping = new RequestMappingHandlerMapping();
        requestMappingHandlerMapping.setOrder(0);
        return requestMappingHandlerMapping;
    }

    @Bean(name={"contentNegotiatingViewResolver"})
    public ContentNegotiatingViewResolver contentNegotiatingViewResolver() {
        ContentNegotiatingViewResolver contentNegotiatingViewResolver = new ContentNegotiatingViewResolver();
        ArrayList<MappingJackson2JsonView> viewList = new ArrayList<MappingJackson2JsonView>(2);
        MappingJackson2JsonView mappingJackson2JsonView = new MappingJackson2JsonView();
        mappingJackson2JsonView.setObjectMapper(this.jacksonObjectMapper());
        viewList.add(mappingJackson2JsonView);
        contentNegotiatingViewResolver.setDefaultViews(viewList);
        ArrayList<InternalResourceViewResolver> viewResolverList = new ArrayList<InternalResourceViewResolver>(1);
        InternalResourceViewResolver internalResourceViewResolver = new InternalResourceViewResolver();
        internalResourceViewResolver.setPrefix("/WEB-INF/pages/");
        internalResourceViewResolver.setSuffix(".jsp");
        viewResolverList.add(internalResourceViewResolver);
        contentNegotiatingViewResolver.setViewResolvers(viewResolverList);
        return contentNegotiatingViewResolver;
    }

    @Bean(name={"simpleMappingExceptionResolver"})
    public SimpleMappingExceptionResolver simpleMappingExceptionResolver() {
        Properties properties = new Properties();
        properties.setProperty("org.springframework.web.servlet.PageNotFound", "pageNotFound");
        properties.setProperty("org.springframework.dao.DataAccessException", "dataAccessFailure");
        properties.setProperty("org.springframework.transaction.TransactionException", "dataAccessFailure");
        SimpleMappingExceptionResolver simpleMappingExceptionResolver = new SimpleMappingExceptionResolver();
        simpleMappingExceptionResolver.setExceptionMappings(properties);
        return simpleMappingExceptionResolver;
    }

    @Bean(name={"resourceBundleMessageSource"})
    public ResourceBundleMessageSource resourceBundleMessageSource() {
        ResourceBundleMessageSource resourceBundleMessageSource = new ResourceBundleMessageSource();
        resourceBundleMessageSource.setBasename("messages");
        return resourceBundleMessageSource;
    }

    @Bean(name={"stringHttpMessageConverter"})
    public StringHttpMessageConverter stringHttpMessageConverter() {
        return new StringHttpMessageConverter();
    }

    @Bean(name={"mappingJackson2HttpMessageConverter"})
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter();
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
        RequestMappingHandlerAdapter requestMappingHandlerAdapter = new RequestMappingHandlerAdapter();
        requestMappingHandlerAdapter.getMessageConverters().add(0, this.mappingJackson2HttpMessageConverter());
        requestMappingHandlerAdapter.getMessageConverters().add(1, this.stringHttpMessageConverter());
        return requestMappingHandlerAdapter;
    }
}

