/*
 * Decompiled with CFR 0.152.
 */
package ncar.manager.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import ncar.common.InvalidRequestException;
import ncar.common.Util;
import ncar.manager.model.DataStructureDiffRequest;
import ncar.manager.model.DataStructureRequest;
import ncar.manager.service.DataStructureService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Controller
@EnableWebMvc
public class DataStructureController {
    static final Logger logger = Logger.getLogger(DataStructureController.class);
    @Autowired
    private DataStructureService dataStructureService;

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getModel"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getModel(@Valid @RequestBody DataStructureRequest input) {
        return this.dataStructureService.getModel();
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getRcp"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getRcp(@Valid @RequestBody DataStructureRequest input) {
        List<String> result;
        try {
            this.dataStructureService.verifyRequest(input);
            result = this.dataStructureService.getRcp(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            result = new ArrayList<String>();
        }
        return ncar.manager.util.Util.convertListToJsonArray(result);
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getEnsMember"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getEnsMember(@Valid @RequestBody DataStructureRequest input) {
        List<String> result;
        try {
            this.dataStructureService.verifyRequest(input);
            result = this.dataStructureService.getEnsMember(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            result = new ArrayList<String>();
        }
        return ncar.manager.util.Util.convertListToJsonArray(result);
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getStatistic"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getStatistic(@Valid @RequestBody DataStructureRequest input) {
        List<String> result;
        try {
            this.dataStructureService.verifyRequest(input);
            result = this.dataStructureService.getStatistic(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            result = new ArrayList<String>();
        }
        return ncar.manager.util.Util.convertListToJsonArray(result);
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getAggregationPeriod"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getAggregationPeriod(@Valid @RequestBody DataStructureRequest input) {
        JsonNode result;
        try {
            this.dataStructureService.verifyRequest(input);
            result = this.dataStructureService.getAggregationPeriod(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            result = new ArrayNode(JsonNodeFactory.instance);
        }
        return result;
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getPeriod"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getPeriod(@Valid @RequestBody DataStructureRequest input) {
        JsonNode result;
        try {
            this.dataStructureService.verifyRequest(input);
            result = this.dataStructureService.getPeriod(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            result = new ArrayNode(JsonNodeFactory.instance);
        }
        return result;
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getDataUrl"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getDataUrl(@Valid @RequestBody DataStructureRequest input) {
        ArrayNode result;
        try {
            this.dataStructureService.verifyRequest(input);
            result = this.dataStructureService.getThreddsUrl(input, this.dataStructureService.getThreddsWmsUrl());
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            result = new ArrayNode(JsonNodeFactory.instance);
        }
        return result;
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/downloadDataUrl"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode downloadDataUrl(@Valid @RequestBody DataStructureRequest input) {
        ArrayNode result;
        try {
            this.dataStructureService.verifyRequest(input);
            result = this.dataStructureService.getThreddsUrl(input, this.dataStructureService.getThreddsNcssUrl());
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            result = new ArrayNode(JsonNodeFactory.instance);
        }
        return result;
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/calculateDiff"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode calculateDiff(@Valid @RequestBody DataStructureDiffRequest request) {
        JsonNode result;
        try {
            this.dataStructureService.verifyRequest(request);
            result = this.dataStructureService.calculateDiff(request);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            result = new ArrayNode(JsonNodeFactory.instance);
        }
        return result;
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getAvailableRegions"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getAvailableRegions() {
        return this.dataStructureService.getAvailableRegionsJson();
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getCountriesByRegion"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public JsonNode getCountriesByRegion(@RequestParam(value="region") String region) {
        try {
            Util.verifyParameter((String)region);
            return this.dataStructureService.getCountriesByRegionJson(region);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ArrayNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getRegionByCountry"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public JsonNode getRegionByCountry(@RequestParam(value="country") String country) {
        try {
            Util.verifyParameter((String)country);
            return this.dataStructureService.getRegionByCountryJson(country);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ArrayNode(JsonNodeFactory.instance);
        }
    }
}

