/*
 * Decompiled with CFR 0.152.
 */
package ncar.manager.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import ncar.common.InvalidRequestException;
import ncar.manager.model.FilePathRequest;
import ncar.manager.service.FeatureService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Controller
@EnableWebMvc
public class FeatureController {
    static final Logger logger = Logger.getLogger(FeatureController.class);
    @Autowired
    private FeatureService featureService;

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST, RequestMethod.OPTIONS}, value={"/getFeatureInfo"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getFeatureInfo(@RequestBody @Valid FilePathRequest input) {
        try {
            this.featureService.verifyRequest(input);
            String filePath = input.getFilePath();
            String lat = input.getLat();
            String lon = input.getLon();
            String layer = input.getLayer();
            String addPeriod = input.getAddPeriod();
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(layer);
            Map<String, List<Float>> fieldToData = this.featureService.getFeatureInfo(fields, filePath, Float.valueOf(lat), Float.valueOf(lon), addPeriod);
            return this.featureService.createJsonForFeatureInfo(fieldToData);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }
}

