/*
 * Decompiled with CFR 0.152.
 */
package ncar.manager.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import ncar.common.InvalidRequestException;
import ncar.common.Util;
import ncar.manager.model.FilePathRequest;
import ncar.manager.model.GraphingRequest;
import ncar.manager.service.GraphingService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Controller
@EnableWebMvc
public class GraphingController {
    static final Logger logger = Logger.getLogger(GraphingController.class);
    @Autowired
    private GraphingService graphingService;

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/viewChart"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getMonthlyDataForFieldsFromFiles(@Valid @RequestBody FilePathRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            String filePath = input.getFilePath();
            String lat = input.getLat();
            String lon = input.getLon();
            String layer = input.getLayer();
            String title = input.getTitle();
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(layer);
            Map<String, List<Float>> fieldToData = this.graphingService.getMonthlyDataForFieldsFromFiles(fields, filePath, Float.valueOf(lat), Float.valueOf(lon));
            return this.graphingService.createJsonForPlotting(fieldToData, title);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/viewRadar"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode viewRadar(@Valid @RequestBody FilePathRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            String filePath = input.getFilePath();
            String lat = input.getLat();
            String lon = input.getLon();
            String layer = input.getLayer();
            String title = input.getTitle();
            String time = input.getTime();
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(layer);
            Map<String, List<Float>> fieldToData = this.graphingService.getStatDataForFieldsFromFiles(fields, filePath, Float.valueOf(lat), Float.valueOf(lon), time);
            return this.graphingService.createJsonForPlotting(fieldToData, title);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/viewDifference"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode viewDifference(@Valid @RequestBody FilePathRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            List<String> filePath = input.getOriginalFiles();
            String lat = input.getLat();
            String lon = input.getLon();
            String layer = input.getLayer();
            if (layer.contains("_diff")) {
                layer = layer.replaceAll("_diff", "");
            }
            String title = input.getTitle();
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(layer);
            Map<String, List<Float>> fieldToData1 = this.graphingService.getMonthlyDataForFieldsFromFiles(fields, filePath.get(0), Float.valueOf(lat), Float.valueOf(lon));
            Map<String, List<Float>> fieldToData2 = this.graphingService.getMonthlyDataForFieldsFromFiles(fields, filePath.get(1), Float.valueOf(lat), Float.valueOf(lon));
            HashMap<String, List<Float>> fieldToData = new HashMap<String, List<Float>>();
            for (Map.Entry<String, List<Float>> entry : fieldToData1.entrySet()) {
                List<Float> data1 = entry.getValue();
                List<Float> data2 = fieldToData2.get(entry.getKey());
                ArrayList<Float> data = new ArrayList<Float>();
                for (int i = 0; i < data1.size(); ++i) {
                    if (data1.get(i) == null || data2.get(i) == null) continue;
                    data.add(Float.valueOf(data1.get(i).floatValue() - data2.get(i).floatValue()));
                }
                fieldToData.put(entry.getKey(), data);
            }
            return this.graphingService.createJsonForPlotting(fieldToData, title);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.GET}, value={"/downloadCsv"})
    public void downloadCsv(@RequestParam(value="filePath") String filePath, @RequestParam(value="layer") String layer, @RequestParam(value="lat") String lat, @RequestParam(value="lon") String lon, HttpServletResponse response) {
        try {
            Util.verifyParameter((String)filePath);
            Util.verifyParameter((String)layer);
            Util.verifyParameter((String)lat);
            Util.verifyParameter((String)lon);
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(layer);
            Map<String, List<Float>> fieldToData = this.graphingService.getMonthlyDataForFieldsFromFiles(fields, filePath, Float.valueOf(lat), Float.valueOf(lon));
            this.graphingService.downloadCsv(fieldToData, response);
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getSeasonalChange"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getSeasonalChange(@RequestBody @Valid GraphingRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            return this.graphingService.getSeasonalChange(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getBoxPlotData"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getBoxPlot(@RequestBody @Valid GraphingRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            return this.graphingService.getBoxPlot(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getTimeSeriesData"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getTimeSeries(@RequestBody @Valid GraphingRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            return this.graphingService.getTimeSeries(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getObsTimeSeriesData"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getObsTimeSeriesData(@RequestBody @Valid GraphingRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            return this.graphingService.getObsTimeSeries(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getMonthlyDecennialData"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getMonthlyDecennialData(@RequestBody @Valid GraphingRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            return this.graphingService.getMonthlyDecennial(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }

    @CrossOrigin
    @RequestMapping(method={RequestMethod.POST}, value={"/getSeasonalCycleObs"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public JsonNode getSeasonalCycleObs(@RequestBody @Valid GraphingRequest input) {
        try {
            this.graphingService.verifyRequest(input);
            return this.graphingService.getSeasonalCycleObs(input);
        }
        catch (InvalidRequestException e) {
            logger.error((Object)e.getMessage());
            return new ObjectNode(JsonNodeFactory.instance);
        }
    }
}

