/*
 * Decompiled with CFR 0.152.
 */
package ncar.manager.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ncar.common.InvalidRequestException;
import ncar.common.Util;
import ncar.manager.model.CountryIso;
import ncar.manager.model.DataStructureDiffRequest;
import ncar.manager.model.DataStructureRequest;
import ncar.manager.model.NetcdfAttributes;
import ncar.manager.model.Project;
import ncar.manager.model.RegionIso;
import ncar.manager.util.MissingConfigDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataStructureService {
    private static final Logger log = LoggerFactory.getLogger(DataStructureService.class);
    private static final String EXTENT = "extent";
    private static final String COUNTRY_NAME = "country_name";
    private static final String COUNTRY_CODE = "country_code";
    private static final String REGION_CODE = "region_code";
    private static final String REGION_NAME = "region_name";
    private static final String PATH_SEPARATOR = File.separator;
    private static final String COUNTRY_CODE_FILE_NAME = PATH_SEPARATOR + "countryISOcodes.json";
    private static final String PROJECTS_FILE_NAME = PATH_SEPARATOR + "projects.json";
    private static final String URL = "url";
    private static final String LAYER = "layer";
    private static final String WMS = "wms";
    private static final String TIME = "time";
    private static final String PATH = "path";
    private final List<RegionIso> regions = new ArrayList<RegionIso>();
    private String threddsWmsUrl;
    private String threddsStatsWmsUrl;
    private String threddsNcssUrl;
    private String statsPath;
    private String baseDir;
    private Project project;

    public DataStructureService() throws MissingConfigDir {
        this.initBaseDir();
        this.initProjects();
        this.initCountryCodes();
    }

    private void initBaseDir() throws MissingConfigDir {
        this.baseDir = System.getProperty("catalina.base") + PATH_SEPARATOR + "content" + PATH_SEPARATOR + "crmeConfig";
        File baseDirFile = new File(this.baseDir);
        if (!baseDirFile.exists()) {
            this.baseDir = System.getProperty("crme.content.root.path");
            if (this.baseDir != null) {
                baseDirFile = new File(this.baseDir);
                if (!baseDirFile.exists()) {
                    MissingConfigDir exception = new MissingConfigDir();
                    log.error(exception.getMessage());
                    throw exception;
                }
            } else {
                MissingConfigDir exception = new MissingConfigDir();
                log.error(exception.getMessage());
                throw exception;
            }
        }
    }

    private void initCountryCodes() {
        try {
            String jsonStr = new String(Files.readAllBytes(Paths.get(this.baseDir + COUNTRY_CODE_FILE_NAME, new String[0])));
            ArrayNode countriesJson = (ArrayNode)new ObjectMapper().readTree(jsonStr);
            for (int i = 0; i < countriesJson.size(); ++i) {
                CountryIso countryIso = new CountryIso();
                ObjectNode countryJson = (ObjectNode)countriesJson.get(i);
                countryIso.setName(countryJson.get(COUNTRY_NAME).textValue());
                countryIso.setCode(countryJson.get(COUNTRY_CODE).textValue());
                String regionCode = countryJson.get(REGION_CODE).textValue();
                RegionIso regionForCountry = null;
                for (RegionIso regionIso : this.regions) {
                    if (!regionIso.getCode().equals(regionCode)) continue;
                    regionForCountry = regionIso;
                    break;
                }
                if (regionForCountry == null) {
                    regionForCountry = new RegionIso();
                    regionForCountry.setCode(regionCode);
                    regionForCountry.setName(countryJson.get(REGION_NAME).textValue());
                    this.regions.add(regionForCountry);
                }
                regionForCountry.getCountries().add(countryIso);
            }
            for (RegionIso regionIso : this.regions) {
                Collections.sort(regionIso.getCountries());
            }
            Collections.sort(this.regions);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            log.error(String.format("Can't read file %s %s", this.baseDir, COUNTRY_CODE_FILE_NAME));
        }
    }

    private void initProjects() {
        try {
            String jsonStr = new String(Files.readAllBytes(Paths.get(this.baseDir + PROJECTS_FILE_NAME, new String[0])));
            ObjectNode projectsJson = (ObjectNode)new ObjectMapper().readTree(jsonStr);
            this.threddsNcssUrl = projectsJson.get("threddsNcssUrl").textValue();
            this.threddsWmsUrl = projectsJson.get("threddsWmsUrl").textValue();
            this.threddsStatsWmsUrl = projectsJson.get("threddsStatsWmsUrl").textValue();
            this.statsPath = projectsJson.get("statsPath").textValue();
            ArrayNode projectsArr = (ArrayNode)projectsJson.get("projects");
            ObjectNode projectJson = (ObjectNode)projectsArr.get(0);
            this.project = new Project();
            this.project.setName(projectJson.get("name").textValue());
            this.project.setAbsolutePath(projectJson.get(PATH).textValue());
            if (projectJson.has("obsPath")) {
                this.project.setObsAbsolutePath(projectJson.get("obsPath").textValue());
            }
            this.project.setActivity(projectJson.get("activity").textValue());
            if (projectJson.get("exclude") != null) {
                this.addExcluded(this.project, projectJson);
            }
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            log.error(String.format("Can't read file %s %s", this.baseDir, PROJECTS_FILE_NAME));
        }
    }

    private void addExcluded(Project project, ObjectNode projectJson) {
        try {
            ArrayNode excludesJson = (ArrayNode)projectJson.get("exclude");
            Iterator iterator = excludesJson.elements();
            while (iterator.hasNext()) {
                JsonNode exclude = (JsonNode)iterator.next();
                project.getExcludes().add(exclude.textValue());
            }
        }
        catch (Exception e) {
            log.error("Exclude element has incorrect format");
        }
    }

    public String getThreddsWmsUrl() {
        return this.threddsWmsUrl;
    }

    public String getThreddsNcssUrl() {
        return this.threddsNcssUrl;
    }

    public JsonNode getAvailableRegionsJson() {
        ArrayNode result = new ArrayNode(JsonNodeFactory.instance);
        for (RegionIso regionIso : this.regions) {
            result.add((JsonNode)regionIso.toJson());
        }
        return result;
    }

    public JsonNode getCountriesByRegionJson(String countryCode) {
        ArrayNode result = new ArrayNode(JsonNodeFactory.instance);
        for (RegionIso regionIso : this.regions) {
            if (!regionIso.getCode().equals(countryCode)) continue;
            for (CountryIso countryIso : regionIso.getCountries()) {
                result.add((JsonNode)countryIso.toJson());
            }
        }
        return result;
    }

    public JsonNode getRegionByCountryJson(String country) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode countries = result.putArray("countries");
        List<CountryIso> countriesArray = null;
        block0: for (RegionIso regionIso : this.regions) {
            for (CountryIso countryIso : regionIso.getCountries()) {
                if (!countryIso.getCode().equals(country)) continue;
                result.put("region", regionIso.getCode());
                countriesArray = regionIso.getCountries();
                continue block0;
            }
        }
        if (countriesArray != null) {
            for (CountryIso countryIso : countriesArray) {
                countries.add((JsonNode)countryIso.toJson());
            }
        }
        return result;
    }

    public List<String> getEnsMember(DataStructureRequest request) {
        List<String> modelIds = this.getValues("");
        Set<String> includedModels = this.getIncludedModels(modelIds);
        String selectedModelId = request.getModel();
        String selectedrcp = request.getRcp();
        ArrayList<String> uniqueEnsMembers = new ArrayList<String>();
        for (String modelId : includedModels) {
            try {
                String[] modelComponents = modelId.split("-regridded-");
                String currentModelId = modelComponents[0];
                String currentrcp = modelComponents[1].split("-")[0];
                String ensMember = modelComponents[1].split("-")[1];
                if (!currentModelId.equals(selectedModelId) || !currentrcp.equals(selectedrcp) || uniqueEnsMembers.contains(ensMember)) continue;
                uniqueEnsMembers.add(ensMember);
            }
            catch (Exception e) {
                log.error(String.format("Can't get ensemble member from the model %s", modelId));
            }
        }
        Collections.sort(uniqueEnsMembers);
        return uniqueEnsMembers;
    }

    private Set<String> getIncludedModels(List<String> modelIds) {
        HashSet<String> includedModels = new HashSet<String>();
        for (String modelId : modelIds) {
            boolean isIncluded = true;
            for (String exclude : this.project.getExcludes()) {
                if (!modelId.contains(exclude)) continue;
                isIncluded = false;
                break;
            }
            if (!isIncluded) continue;
            includedModels.add(modelId);
        }
        return includedModels;
    }

    public String createLayerName(DataStructureRequest request) {
        String model = request.getModel();
        String variable = request.getVariable();
        String statistic = request.getStatistic();
        String rcp = request.getRcp();
        String ensMember = request.getEnsMember();
        String fullModelId = rcp == null ? model + "-" + ensMember : model + "-regridded-" + rcp + "-" + ensMember;
        String aggregationPeriod = this.convertAggPeriod(request.getAggregationPeriod());
        String searchKey = fullModelId + PATH_SEPARATOR + variable + PATH_SEPARATOR + statistic + PATH_SEPARATOR + aggregationPeriod;
        List<String> values = rcp == null ? this.getValuesObs(searchKey) : this.getValues(searchKey);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    private String convertAggPeriod(String aggregationPeriod) {
        String period = "";
        if (aggregationPeriod != null) {
            period = "ann".equals(aggregationPeriod) ? "annual" : "monthly";
        }
        return period;
    }

    private String createFileName(DataStructureRequest request, String layerName, String extension) {
        return layerName + "_" + this.project.getActivity() + "_" + this.convertAggPeriod(request.getAggregationPeriod()) + "_" + request.getModel() + "-regridded-" + request.getRcp() + "-" + request.getEnsMember() + "_" + request.getPeriod() + extension;
    }

    private String createUrl(DataStructureRequest threddsRequest, String serviceUrl, String fileName, String layerName) {
        String modelId = threddsRequest.getModel();
        String rcp = threddsRequest.getRcp();
        String ensMember = threddsRequest.getEnsMember();
        String fullModelId = modelId + "-regridded-" + rcp + "-" + ensMember;
        String aggregationPeriod = this.convertAggPeriod(threddsRequest.getAggregationPeriod());
        return serviceUrl + PATH_SEPARATOR + this.project.getActivity() + PATH_SEPARATOR + fullModelId + PATH_SEPARATOR + threddsRequest.getVariable() + PATH_SEPARATOR + threddsRequest.getStatistic() + PATH_SEPARATOR + aggregationPeriod + PATH_SEPARATOR + layerName + PATH_SEPARATOR + threddsRequest.getPeriod() + PATH_SEPARATOR + fileName;
    }

    public String createFilePath(DataStructureRequest threddsRequest, String layerName) {
        String path;
        String fullModelId;
        String modelId = threddsRequest.getModel();
        String rcp = threddsRequest.getRcp();
        String ensMember = threddsRequest.getEnsMember();
        if (rcp == null) {
            fullModelId = modelId + "-" + ensMember;
            path = this.project.getObsAbsolutePath();
        } else {
            fullModelId = modelId + "-regridded-" + rcp + "-" + ensMember;
            path = this.project.getAbsolutePath();
        }
        String aggregationPeriod = this.convertAggPeriod(threddsRequest.getAggregationPeriod());
        return path + PATH_SEPARATOR + fullModelId + PATH_SEPARATOR + threddsRequest.getVariable() + PATH_SEPARATOR + threddsRequest.getStatistic() + PATH_SEPARATOR + aggregationPeriod + PATH_SEPARATOR + layerName + PATH_SEPARATOR + threddsRequest.getPeriod();
    }

    public JsonNode getPeriod(DataStructureRequest request) {
        ArrayNode jsonArray = new ArrayNode(JsonNodeFactory.instance);
        String modelId = request.getModel();
        String baseSeries = request.getVariable();
        String statistic = request.getStatistic();
        String rcp = request.getRcp();
        String ensMember = request.getEnsMember();
        String fullModelId = modelId + "-regridded-" + rcp + "-" + ensMember;
        String aggregationPeriod = this.convertAggPeriod(request.getAggregationPeriod());
        String searchKey = fullModelId + PATH_SEPARATOR + baseSeries + PATH_SEPARATOR + statistic + PATH_SEPARATOR + aggregationPeriod;
        List<String> layerNames = this.getValues(searchKey);
        if (!layerNames.isEmpty()) {
            String layerName = this.getValues(searchKey).get(0);
            searchKey = searchKey + PATH_SEPARATOR + layerName;
            List<String> periods = this.getValues(searchKey);
            periods.forEach(arg_0 -> ((ArrayNode)jsonArray).add(arg_0));
        }
        if (jsonArray.size() == 0) {
            String problemDirectory = this.project.getAbsolutePath() + searchKey;
            log.error(String.format("Can't list directories in: %s ", problemDirectory));
        }
        return jsonArray;
    }

    public JsonNode getThreddsUrl(DataStructureRequest request, String serviceUrl) {
        ObjectNode jsonObject = new ObjectNode(JsonNodeFactory.instance);
        String layerName = this.createLayerName(request);
        if (layerName != null) {
            String fileName = this.createFileName(request, layerName, ".nc");
            String urlStr = this.createUrl(request, serviceUrl, fileName, layerName);
            String filePath = this.createFilePath(request, layerName) + PATH_SEPARATOR + fileName;
            jsonObject.put(URL, urlStr);
            jsonObject.put(LAYER, layerName);
            jsonObject.putArray(EXTENT);
            if (serviceUrl.contains(WMS)) {
                NetcdfAttributes netcdfVariableAttributes = ncar.manager.util.Util.getNetcdfVariableAttributes(filePath, layerName, request.getAggregationPeriod());
                if (netcdfVariableAttributes.getBoundingBox() != null) {
                    ArrayNode extentJson = new ArrayNode(JsonNodeFactory.instance);
                    extentJson.add(netcdfVariableAttributes.getBoundingBox().getLonMin());
                    extentJson.add(netcdfVariableAttributes.getBoundingBox().getLatMin());
                    extentJson.add(netcdfVariableAttributes.getBoundingBox().getLonMax());
                    extentJson.add(netcdfVariableAttributes.getBoundingBox().getLatMax());
                    ((ArrayNode)jsonObject.get(EXTENT)).add((JsonNode)extentJson);
                }
                jsonObject.put(TIME, netcdfVariableAttributes.getTime());
                jsonObject.put(PATH, filePath);
            }
        }
        return jsonObject;
    }

    public JsonNode calculateDiff(DataStructureDiffRequest request) {
        DataStructureRequest threddsRequest1 = new DataStructureRequest();
        threddsRequest1.setAggregationPeriod(request.getAggregationPeriod1());
        threddsRequest1.setPeriod(request.getPeriod1());
        threddsRequest1.setVariable(request.getVariable1());
        threddsRequest1.setStatistic(request.getStatistic1());
        threddsRequest1.setModel(request.getModelId1());
        threddsRequest1.setRcp(request.getRcp1());
        threddsRequest1.setEnsMember(request.getEnsMember1());
        DataStructureRequest threddsRequest2 = new DataStructureRequest();
        threddsRequest2.setAggregationPeriod(request.getAggregationPeriod2());
        threddsRequest2.setPeriod(request.getPeriod2());
        threddsRequest2.setVariable(request.getVariable2());
        threddsRequest2.setStatistic(request.getStatistic2());
        threddsRequest2.setModel(request.getModelId2());
        threddsRequest2.setRcp(request.getRcp2());
        threddsRequest2.setEnsMember(request.getEnsMember2());
        String layerName2 = this.createLayerName(threddsRequest2);
        String fileName2 = this.createFileName(threddsRequest2, layerName2, ".nc");
        String filePath2 = this.createFilePath(threddsRequest2, layerName2) + PATH_SEPARATOR + fileName2;
        ObjectNode jsonObject = new ObjectNode(JsonNodeFactory.instance);
        jsonObject.putArray("originalFiles");
        ArrayNode jsonArray = (ArrayNode)jsonObject.get("originalFiles");
        String layerName1 = this.createLayerName(threddsRequest1);
        String fileName1 = this.createFileName(threddsRequest1, layerName1, ".nc");
        String filePath1 = this.createFilePath(threddsRequest1, layerName1) + PATH_SEPARATOR + fileName1;
        jsonArray.add(filePath1);
        jsonArray.add(filePath2);
        NetcdfAttributes netcdfAttributes = ncar.manager.util.Util.createDifferenceFile(filePath1, layerName1, request.getAggregationPeriod1(), filePath2, layerName2, request.getAggregationPeriod2(), this.statsPath);
        if (netcdfAttributes.getFileName() != null) {
            jsonObject.put(URL, this.threddsStatsWmsUrl + netcdfAttributes.getFileName());
            jsonObject.put(LAYER, netcdfAttributes.getLayer());
            jsonObject.put("units", netcdfAttributes.getUnits());
            jsonObject.put(PATH, this.statsPath + netcdfAttributes.getFileName());
            if (netcdfAttributes.getBoundingBox() != null) {
                jsonObject.putArray(EXTENT);
                ArrayNode extentJson = (ArrayNode)jsonObject.get(EXTENT);
                extentJson.add(netcdfAttributes.getBoundingBox().getLonMin());
                extentJson.add(netcdfAttributes.getBoundingBox().getLatMin());
                extentJson.add(netcdfAttributes.getBoundingBox().getLonMax());
                extentJson.add(netcdfAttributes.getBoundingBox().getLatMax());
            }
            jsonObject.put("success", true);
        } else {
            jsonObject.put("success", false);
        }
        return jsonObject;
    }

    public List<String> getRcp(DataStructureRequest request) {
        List<String> modelIds = this.getValues("");
        Set<String> includedModels = this.getIncludedModels(modelIds);
        String selectedModelId = request.getModel();
        return this.getRcpForModel(includedModels, selectedModelId);
    }

    public List<String> getRcpForPlots(DataStructureRequest request) {
        List<String> modelIds = this.getValues("");
        HashSet<String> includedModels = new HashSet<String>();
        for (String modelId : modelIds) {
            if (!modelId.contains("-" + request.getEnsMember())) continue;
            includedModels.add(modelId);
        }
        String selectedModelId = request.getModel();
        return this.getRcpForModel(includedModels, selectedModelId);
    }

    private List<String> getRcpForModel(Set<String> includedModels, String selectedModelId) {
        ArrayList<String> uniqueRcps = new ArrayList<String>();
        for (String modelId : includedModels) {
            try {
                String[] modelComponents = modelId.split("-regridded-");
                String currentModelId = modelComponents[0];
                String rcp = modelComponents[1].split("-")[0];
                if (!currentModelId.equals(selectedModelId) || uniqueRcps.contains(rcp)) continue;
                uniqueRcps.add(rcp);
            }
            catch (Exception e) {
                log.error(String.format("Can't get rcp from the model %s", modelId));
            }
        }
        Collections.sort(uniqueRcps);
        return uniqueRcps;
    }

    private List<String> getValues(String searchKey) {
        ArrayList<String> finalItems = new ArrayList<String>();
        Path dir = FileSystems.getDefault().getPath(this.project.getAbsolutePath(), searchKey);
        try (DirectoryStream<Path> directories = Files.newDirectoryStream(dir, path -> path.toFile().isDirectory());){
            directories.forEach(k -> finalItems.add(k.toFile().getName()));
            Collections.sort(finalItems);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return finalItems;
    }

    private List<String> getValuesObs(String searchKey) {
        ArrayList<String> finalItems = new ArrayList<String>();
        Path dir = FileSystems.getDefault().getPath(this.project.getObsAbsolutePath(), searchKey);
        try (DirectoryStream<Path> directories = Files.newDirectoryStream(dir, path -> path.toFile().isDirectory());){
            directories.forEach(k -> finalItems.add(k.toFile().getName()));
            Collections.sort(finalItems);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return finalItems;
    }

    public List<String> getStatistic(DataStructureRequest request) {
        String model = request.getModel();
        String variable = request.getVariable();
        String rcp = request.getRcp();
        String ensMember = request.getEnsMember();
        String fullModel = model + "-regridded-" + rcp + "-" + ensMember;
        String searchKey = fullModel + PATH_SEPARATOR + variable;
        return this.getValues(searchKey);
    }

    public JsonNode getAggregationPeriod(DataStructureRequest request) {
        ArrayNode jsonArray = new ArrayNode(JsonNodeFactory.instance);
        String modelId = request.getModel();
        String baseSeries = request.getVariable();
        String statistic = request.getStatistic();
        String rcp = request.getRcp();
        String ensMember = request.getEnsMember();
        String searchKey = "";
        String fullModelId = modelId + "-regridded-" + rcp + "-" + ensMember;
        searchKey = fullModelId + PATH_SEPARATOR + baseSeries + PATH_SEPARATOR + statistic;
        List<String> periods = this.getValues(searchKey);
        ArrayList<String> periodUnordered = new ArrayList<String>();
        for (String period : periods) {
            if (period.equals("annual")) {
                periodUnordered.add("ann");
                continue;
            }
            if (!period.equals("monthly")) continue;
            periodUnordered.addAll(ncar.manager.util.Util.monthlyAbbv);
        }
        periodUnordered.forEach(arg_0 -> ((ArrayNode)jsonArray).add(arg_0));
        if (jsonArray.size() == 0) {
            log.error(String.format("Can't get aggregation period for %s", searchKey));
        }
        return jsonArray;
    }

    public JsonNode getModel() {
        List<String> modelIds = this.getValues("");
        ArrayList<String> uniqueModels = new ArrayList<String>();
        for (String modelId : modelIds) {
            try {
                boolean isIncluded = true;
                for (String exclude : this.project.getExcludes()) {
                    if (!modelId.contains(exclude)) continue;
                    isIncluded = false;
                    break;
                }
                String name = modelId.split("-regridded-")[0];
                if (!isIncluded || uniqueModels.contains(name)) continue;
                uniqueModels.add(modelId.split("-regridded-")[0]);
            }
            catch (Exception e) {
                log.error(String.format("Can't add model %s", modelId));
            }
        }
        Collections.sort(uniqueModels);
        ArrayNode jsonArray = new ArrayNode(JsonNodeFactory.instance);
        uniqueModels.forEach(arg_0 -> ((ArrayNode)jsonArray).add(arg_0));
        return jsonArray;
    }

    public void verifyRequest(DataStructureRequest request) throws InvalidRequestException {
        Util.verifyParameter((String)request.getAggregationPeriod());
        Util.verifyParameter((String)request.getPeriod());
        Util.verifyParameter((String)request.getVariable());
        Util.verifyParameter((String)request.getStatistic());
        Util.verifyParameter((String)request.getModel());
        Util.verifyParameter((String)request.getRcp());
        Util.verifyParameter((String)request.getEnsMember());
    }

    public void verifyRequest(DataStructureDiffRequest request) throws InvalidRequestException {
        Util.verifyParameter((String)request.getAggregationPeriod1());
        Util.verifyParameter((String)request.getPeriod1());
        Util.verifyParameter((String)request.getVariable1());
        Util.verifyParameter((String)request.getStatistic1());
        Util.verifyParameter((String)request.getModelId1());
        Util.verifyParameter((String)request.getRcp1());
        Util.verifyParameter((String)request.getEnsMember1());
        Util.verifyParameter((String)request.getAggregationPeriod2());
        Util.verifyParameter((String)request.getPeriod2());
        Util.verifyParameter((String)request.getVariable2());
        Util.verifyParameter((String)request.getStatistic2());
        Util.verifyParameter((String)request.getModelId2());
        Util.verifyParameter((String)request.getRcp2());
        Util.verifyParameter((String)request.getEnsMember2());
    }

    public String createObsTimeseriesPath(DataStructureRequest dataStructureRequest) {
        String path = this.project.getObsAbsolutePath() + "/cru-ts4.04-timeseries/" + dataStructureRequest.getVariable() + "/mean/annual/timeseries-" + dataStructureRequest.getVariable() + "-annual-mean/" + dataStructureRequest.getPeriod() + "/";
        return path;
    }
}

