/*
 * Decompiled with CFR 0.152.
 */
package ncar.manager.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import ncar.common.InvalidRequestException;
import ncar.manager.model.FilePathRequest;
import ncar.manager.util.Util;
import org.springframework.stereotype.Service;

@Service
public class FeatureService {
    public JsonNode createJsonForFeatureInfo(Map<String, List<Float>> fieldToData) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        if (fieldToData.isEmpty()) {
            result.put("value", "N/A");
        } else {
            for (Map.Entry<String, List<Float>> entry : fieldToData.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    result.put("value", "N/A");
                    continue;
                }
                result.put("value", entry.getValue().get(0));
            }
        }
        return result;
    }

    public Map<String, List<Float>> getFeatureInfo(List<String> fields, String filePath, Float lat, Float lon, String addPeriod) {
        return Util.getDataForFieldsFromFile(fields, filePath, lat, lon, addPeriod);
    }

    public void verifyRequest(FilePathRequest request) throws InvalidRequestException {
        if (!request.getFilePath().endsWith(".nc")) {
            throw new InvalidRequestException(request.getFilePath());
        }
        try {
            Double.parseDouble(request.getLat());
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException(request.getLat());
        }
        try {
            Double.parseDouble(request.getLon());
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException(request.getLon());
        }
        ncar.common.Util.verifyParameter((String)request.getTitle());
        ncar.common.Util.verifyParameter((String)request.getLayer());
        ncar.common.Util.verifyParameter((String)request.getTime());
        ncar.common.Util.verifyParameter((String)request.getAddPeriod());
        List<String> files = request.getOriginalFiles();
        if (files != null) {
            for (String s : files) {
                ncar.common.Util.verifyParameter((String)s);
            }
        }
    }
}

