/*
 * Decompiled with CFR 0.152.
 */
package ncar.manager.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import ncar.common.InvalidRequestException;
import ncar.common.Util;
import ncar.manager.model.DataStructureRequest;
import ncar.manager.model.FilePathRequest;
import ncar.manager.model.GraphingRequest;
import ncar.manager.service.DataStructureService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Service
@EnableWebMvc
public class GraphingService {
    private static final Logger log = LoggerFactory.getLogger(GraphingService.class);
    private static final Color[] colors = new Color[]{new Color(115, 138, 158), Color.red, Color.orange, Color.yellow, Color.green, Color.blue, new Color(153, 102, 255), Color.gray};
    private static final String[] stats = new String[]{"min", "median", "mean", "max"};
    private static final String BACKGROUND_COLOR = "backgroundColor";
    private static final String BORDER_COLOR = "borderColor";
    private static final String FILL = "fill";
    private static final String X = "x";
    private static final String Y = "y";
    @Autowired
    private DataStructureService dataStructureService;

    private static String toHexString(Color color) {
        Color newColor = color;
        if (color == null) {
            newColor = Color.BLACK;
        }
        return "#" + Integer.toHexString(newColor.getRGB()).substring(2);
    }

    private static String followCvsFormat(Object value) {
        String result = String.valueOf(value);
        if (result.contains("\"")) {
            result = result.replace("\"", "\"\"");
        }
        return result;
    }

    public Map<String, List<Float>> getMonthlyDataForFieldsFromFiles(List<String> fields, String path, Float lat, Float lon) {
        HashMap<String, List<Float>> result = new HashMap<String, List<Float>>();
        String currentPath = path;
        ArrayList<String> currentFields = new ArrayList<String>();
        for (String field : fields) {
            if (field.contains("annual")) {
                currentPath = currentPath.replaceAll("annual", "monthly");
                currentFields.add(field.replaceAll("annual", "monthly"));
            } else {
                currentFields.add(field);
            }
            Map<String, List<Float>> data = ncar.manager.util.Util.getDataForFieldsFromFile(currentFields, currentPath, lat, lon, null);
            result.putAll(data);
        }
        return result;
    }

    public ObjectNode createJsonForPlotting(Map<String, List<Float>> fieldToData, String title) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        result.putArray("data");
        ArrayNode data = (ArrayNode)result.get("data");
        int colorInd = 0;
        for (Map.Entry<String, List<Float>> entry : fieldToData.entrySet()) {
            ObjectNode series = new ObjectNode(JsonNodeFactory.instance);
            series.putArray("data");
            series.put(BACKGROUND_COLOR, GraphingService.toHexString(colors[colorInd]));
            series.put(BORDER_COLOR, GraphingService.toHexString(colors[colorInd]));
            series.put("label", title);
            series.put(FILL, false);
            ArrayNode seriesData = (ArrayNode)series.get("data");
            for (int i = 0; i < entry.getValue().size(); ++i) {
                ObjectNode dataNode = new ObjectNode(JsonNodeFactory.instance);
                dataNode.put(X, i);
                dataNode.put(Y, entry.getValue().get(i));
                seriesData.add((JsonNode)dataNode);
            }
            data.add((JsonNode)series);
            ++colorInd;
        }
        result.put("success", true);
        return result;
    }

    public Map<String, List<Float>> getStatDataForFieldsFromFiles(List<String> fields, String path, Float lat, Float lon, String time) {
        HashMap<String, List<Float>> result = new HashMap<String, List<Float>>();
        String stat = null;
        String fieldStat = null;
        if (path.contains("/min/")) {
            stat = "min";
            fieldStat = "min";
        } else if (path.contains("/median/")) {
            stat = "median";
            fieldStat = "med";
        } else if (path.contains("/mean/")) {
            stat = "mean";
            fieldStat = "avg";
        } else if (path.contains("/max/")) {
            stat = "max";
            fieldStat = "max";
        }
        if (stat != null) {
            for (String field : fields) {
                for (String currentStat : stats) {
                    String currentField;
                    ArrayList<String> currentFields = new ArrayList<String>();
                    switch (currentStat) {
                        case "median": {
                            currentField = field.replaceAll(fieldStat, "med");
                            break;
                        }
                        case "mean": {
                            currentField = field.replaceAll(fieldStat, "avg");
                            break;
                        }
                        default: {
                            currentField = field.replaceAll(fieldStat, currentStat);
                        }
                    }
                    currentFields.add(currentField);
                    String currentPath = path.replaceAll(field, currentField).replaceAll(stat, currentStat);
                    Map<String, List<Float>> data = ncar.manager.util.Util.getDataForFieldsFromFile(currentFields, currentPath, lat, lon, time);
                    if (!result.containsKey(field)) {
                        result.put(field, new ArrayList());
                    }
                    if (data.isEmpty()) {
                        ((List)result.get(field)).add(null);
                        continue;
                    }
                    ((List)result.get(field)).add(data.get(currentFields.get(0)).get(0));
                }
            }
        }
        return result;
    }

    public Map<String, List<Float>> getMonthlyDataForFieldsFromDiffFiles(List<String> fields, String path, Float lat, Float lon) {
        HashMap<String, List<Float>> result = new HashMap<String, List<Float>>();
        ArrayList<String> currentFields = new ArrayList<String>();
        for (String field : fields) {
            currentFields.add(field);
            Map<String, List<Float>> data = ncar.manager.util.Util.getDataForFieldsFromFile(currentFields, path, lat, lon, null);
            result.putAll(data);
        }
        return result;
    }

    public void downloadCsv(Map<String, List<Float>> fieldToData, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"data.csv\"");
        StringBuilder sb = new StringBuilder();
        char separators = ',';
        for (Map.Entry<String, List<Float>> entry : fieldToData.entrySet()) {
            sb.append(entry.getKey());
            for (Float value : entry.getValue()) {
                sb.append(separators);
                sb.append(GraphingService.followCvsFormat(value));
            }
            sb.append("\n");
        }
        byte[] bytes = sb.toString().getBytes();
        try {
            ServletOutputStream out = response.getOutputStream();
            Object object = null;
            try {
                out.write(bytes);
                out.flush();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public JsonNode getSeasonalChange(GraphingRequest input) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        result.putArray("seasonalChange");
        result.putArray("labels");
        ArrayNode seasonalChange = (ArrayNode)result.get("seasonalChange");
        DataStructureRequest dataStructureRequest = new DataStructureRequest(input);
        dataStructureRequest.setStatistic(input.getStatistics().get(0));
        dataStructureRequest.setAggregationPeriod("");
        List<String> rcpList = input.getRcps();
        result.put("unit", "");
        if (rcpList == null) {
            rcpList = this.dataStructureService.getRcp(dataStructureRequest);
        }
        for (String rcp : rcpList) {
            dataStructureRequest.setRcp(rcp);
            List<String> ensMemberList = input.getEnsMembers();
            if (ensMemberList == null) {
                ensMemberList = this.dataStructureService.getEnsMember(dataStructureRequest);
            }
            block12: for (String ensMember : ensMemberList) {
                dataStructureRequest.setEnsMember(ensMember);
                ObjectNode seriesObj = new ObjectNode(JsonNodeFactory.instance);
                String layerName = this.dataStructureService.createLayerName(dataStructureRequest);
                String filePath = this.dataStructureService.createFilePath(dataStructureRequest, layerName);
                File[] csvFiles = new File(filePath).listFiles((dir1, name) -> name.endsWith(input.getSpatialId() + ".csv"));
                if (csvFiles == null || csvFiles.length != 1) continue;
                Path path = Paths.get(csvFiles[0].getAbsolutePath(), new String[0]);
                try {
                    BufferedReader br = Files.newBufferedReader(path);
                    Throwable throwable = null;
                    try {
                        String line = br.readLine();
                        if (result.get("labels").size() == 0) {
                            this.createLabelsAndUnit(result, line);
                        }
                        while ((line = br.readLine()) != null) {
                            List<String> columns = Arrays.asList(line.trim().split(","));
                            if (columns.isEmpty() || !columns.get(0).equals(input.getSpaceId())) continue;
                            seriesObj.put("model", input.getModel() + "-regridded-" + rcp + "-" + dataStructureRequest.getEnsMember());
                            seriesObj.putArray("data");
                            ArrayNode dataArray = (ArrayNode)seriesObj.get("data");
                            this.parseLineIntoArray(columns, dataArray);
                            seasonalChange.add((JsonNode)seriesObj);
                            continue block12;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
        if (seasonalChange.size() == 0) {
            result.put("success", false);
            result.remove("seasonalChange");
            result.remove("labels");
            result.remove("unit");
        } else {
            this.prepareResponse(result, input);
            result.put("statistic", input.getStatistics().get(0));
        }
        return result;
    }

    public JsonNode getSeasonalCycleObs(GraphingRequest input) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        result.putArray("seasonalCycleObs");
        result.putArray("labels");
        ArrayNode seasonalCycleObs = (ArrayNode)result.get("seasonalCycleObs");
        DataStructureRequest dataStructureRequest = new DataStructureRequest(input);
        dataStructureRequest.setAggregationPeriod("monthly");
        dataStructureRequest.setEnsMember("climatology");
        dataStructureRequest.setModel("cru-ts4.04");
        String statistic = input.getStatistics() == null || input.getStatistics().isEmpty() ? "mean" : input.getStatistics().get(0);
        dataStructureRequest.setStatistic(statistic);
        result.put("unit", "");
        String layerName = this.dataStructureService.createLayerName(dataStructureRequest);
        String filePath = this.dataStructureService.createFilePath(dataStructureRequest, layerName);
        File[] csvFiles = new File(filePath).listFiles((dir1, name) -> name.endsWith(input.getSpatialId() + ".csv"));
        if (csvFiles != null && csvFiles.length == 1) {
            Path path = Paths.get(csvFiles[0].getAbsolutePath(), new String[0]);
            try (BufferedReader br = Files.newBufferedReader(path);){
                String line = br.readLine();
                if (result.get("labels").size() == 0) {
                    this.createLabelsAndUnit(result, line);
                }
                while ((line = br.readLine()) != null) {
                    List<String> columns = Arrays.asList(line.trim().split(","));
                    if (columns.isEmpty() || !columns.get(0).equals(input.getSpaceId())) continue;
                    this.parseLineIntoArray(columns, seasonalCycleObs);
                    break;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        if (seasonalCycleObs.size() == 0) {
            result.put("success", false);
            result.remove("seasonalCycleObs");
            result.remove("labels");
            result.remove("unit");
        } else {
            this.prepareResponse(result, input);
            result.put("statistic", dataStructureRequest.getStatistic());
        }
        return result;
    }

    private void createLabelsAndUnit(ObjectNode result, String line) {
        List<String> columns = Arrays.asList(line.split(","));
        if (columns.size() > 1) {
            try {
                result.put("unit", columns.get(1).split("_")[1].trim());
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            ArrayNode labels = (ArrayNode)result.get("labels");
            for (int i = 1; i < columns.size(); ++i) {
                try {
                    labels.add(columns.get(i).split("_")[0].trim());
                    continue;
                }
                catch (Exception e) {
                    labels.add(columns.get(i).trim());
                }
            }
        }
    }

    private void parseLineIntoArray(List<String> columns, ArrayNode dataArray) {
        for (int i = 1; i < columns.size(); ++i) {
            float value = Float.parseFloat(columns.get(i));
            if (value == -999.0f) {
                dataArray.addNull();
                continue;
            }
            dataArray.add(value);
        }
    }

    public JsonNode getBoxPlot(GraphingRequest input) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        result.putArray("boxPlot");
        result.putArray("labels");
        DataStructureRequest dataStructureRequest = new DataStructureRequest(input);
        dataStructureRequest.setEnsMember("boxplot");
        dataStructureRequest.setAggregationPeriod("ann");
        dataStructureRequest.setStatistic("mean");
        ArrayNode boxPlot = (ArrayNode)result.get("boxPlot");
        ArrayNode labels = new ArrayNode(JsonNodeFactory.instance);
        result.put("unit", "");
        List<String> rcpList = input.getRcp() == null ? this.dataStructureService.getRcpForPlots(dataStructureRequest) : input.getRcps();
        block11: for (String rcp : rcpList) {
            labels.add(rcp);
            ObjectNode seriesObj = new ObjectNode(JsonNodeFactory.instance);
            dataStructureRequest.setRcp(rcp);
            String layerName = this.dataStructureService.createLayerName(dataStructureRequest);
            String filePath = this.dataStructureService.createFilePath(dataStructureRequest, layerName);
            File[] csvFiles = new File(filePath).listFiles((dir1, name) -> name.endsWith(input.getSpatialId() + ".csv"));
            if (csvFiles == null || csvFiles.length != 1) continue;
            Path path = Paths.get(csvFiles[0].getAbsolutePath(), new String[0]);
            try {
                BufferedReader br = Files.newBufferedReader(path);
                Throwable throwable = null;
                try {
                    String line = br.readLine();
                    this.createLabelsAndUnit(result, line);
                    while ((line = br.readLine()) != null) {
                        List<String> columns = Arrays.asList(line.trim().split(","));
                        if (!columns.get(0).equals(input.getSpaceId())) continue;
                        seriesObj.put("model", input.getModel() + "-regridded-" + rcp + "-boxplot");
                        seriesObj.putArray("data");
                        ArrayNode dataArray = (ArrayNode)seriesObj.get("data");
                        this.parseLineIntoArray(columns, dataArray);
                        boxPlot.add((JsonNode)seriesObj);
                        continue block11;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        if (boxPlot.size() == 0) {
            result.put("success", false);
            result.remove("boxPlot");
            result.remove("labels");
            result.remove("unit");
        } else {
            ArrayNode l = result.putArray("labels");
            l.addAll(labels);
            this.prepareResponse(result, input);
        }
        return result;
    }

    public JsonNode getTimeSeries(GraphingRequest input) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        result.putArray("timeSeries");
        result.putArray("labels");
        ArrayNode timeSeries = (ArrayNode)result.get("timeSeries");
        result.put("unit", "");
        DataStructureRequest dataStructureRequest = new DataStructureRequest(input);
        dataStructureRequest.setEnsMember("timeseries");
        dataStructureRequest.setAggregationPeriod("ann");
        List<String> rcpList = input.getRcp() == null ? this.dataStructureService.getRcpForPlots(dataStructureRequest) : input.getRcps();
        for (String rcp : rcpList) {
            dataStructureRequest.setRcp(rcp);
            List<String> statisticList = input.getStatistic() == null ? this.dataStructureService.getStatistic(dataStructureRequest) : input.getStatistics();
            block12: for (String statistic : statisticList) {
                ObjectNode seriesObj = new ObjectNode(JsonNodeFactory.instance);
                dataStructureRequest.setStatistic(statistic);
                String layerName = this.dataStructureService.createLayerName(dataStructureRequest);
                String filePath = this.dataStructureService.createFilePath(dataStructureRequest, layerName);
                File[] csvFiles = new File(filePath).listFiles((dir1, name) -> name.endsWith(input.getSpatialId() + ".csv"));
                if (csvFiles == null || csvFiles.length != 1) continue;
                Path path = Paths.get(csvFiles[0].getAbsolutePath(), new String[0]);
                try {
                    BufferedReader br = Files.newBufferedReader(path);
                    Throwable throwable = null;
                    try {
                        String line = br.readLine();
                        this.createLabelsAndUnit(result, line);
                        while ((line = br.readLine()) != null) {
                            List<String> columns = Arrays.asList(line.trim().split(","));
                            if (!columns.get(0).equals(input.getSpaceId())) continue;
                            seriesObj.put("model", input.getModel() + "-regridded-" + rcp + "-" + "timeseries");
                            seriesObj.put("statistic", statistic);
                            seriesObj.putArray("data");
                            ArrayNode dataArray = (ArrayNode)seriesObj.get("data");
                            this.parseLineIntoArray(columns, dataArray);
                            timeSeries.add((JsonNode)seriesObj);
                            continue block12;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
        if (timeSeries.size() == 0) {
            result.put("success", false);
            result.remove("timeSeries");
            result.remove("labels");
            result.remove("unit");
        } else {
            this.prepareResponse(result, input);
        }
        return result;
    }

    public JsonNode getObsTimeSeries(GraphingRequest input) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        result.putArray("obsTimeSeries");
        result.putArray("labels");
        ArrayNode timeSeries = (ArrayNode)result.get("obsTimeSeries");
        result.put("unit", "");
        DataStructureRequest dataStructureRequest = new DataStructureRequest(input);
        dataStructureRequest.setEnsMember("timeseries");
        dataStructureRequest.setAggregationPeriod("ann");
        dataStructureRequest.setModel("cru-ts4.04");
        dataStructureRequest.setStatistic("mean");
        String layerName = this.dataStructureService.createLayerName(dataStructureRequest);
        String filePath = this.dataStructureService.createFilePath(dataStructureRequest, layerName);
        File[] csvFiles = new File(filePath).listFiles((dir1, name) -> name.endsWith(input.getSpatialId() + ".csv"));
        if (csvFiles != null) {
            block11: for (File csvFile : csvFiles) {
                ObjectNode seriesObj = new ObjectNode(JsonNodeFactory.instance);
                Path path = Paths.get(csvFile.getAbsolutePath(), new String[0]);
                String type = "non-smoothed";
                if (csvFile.getName().contains("smooth_")) {
                    type = "smoothed";
                }
                try (BufferedReader br = Files.newBufferedReader(path);){
                    String line = br.readLine();
                    this.createLabelsAndUnit(result, line);
                    while ((line = br.readLine()) != null) {
                        List<String> columns = Arrays.asList(line.trim().split(","));
                        if (!columns.get(0).equals(input.getSpaceId())) continue;
                        seriesObj.put("type", type);
                        seriesObj.putArray("data");
                        ArrayNode dataArray = (ArrayNode)seriesObj.get("data");
                        this.parseLineIntoArray(columns, dataArray);
                        timeSeries.add((JsonNode)seriesObj);
                        continue block11;
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
        if (timeSeries.size() == 0) {
            result.put("success", false);
            result.remove("obsTimeSeries");
            result.remove("labels");
            result.remove("unit");
        } else {
            this.prepareResponse(result, input);
        }
        return result;
    }

    public JsonNode getMonthlyDecennial(GraphingRequest input) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        result.putArray("monthlyDecennial");
        ArrayNode monthlyDecennial = (ArrayNode)result.get("monthlyDecennial");
        result.put("unit", "");
        DataStructureRequest dataStructureRequest = new DataStructureRequest(input);
        dataStructureRequest.setEnsMember("heatplot");
        dataStructureRequest.setAggregationPeriod("monthly");
        dataStructureRequest.setModel("cru-ts4.04");
        dataStructureRequest.setStatistic("mean");
        String layerName = this.dataStructureService.createLayerName(dataStructureRequest);
        String filePath = this.dataStructureService.createFilePath(dataStructureRequest, layerName);
        File[] csvFiles = new File(filePath).listFiles((dir1, name) -> name.endsWith(input.getSpatialId() + ".csv"));
        if (csvFiles != null && csvFiles.length == 1) {
            Path path = Paths.get(csvFiles[0].getAbsolutePath(), new String[0]);
            try (BufferedReader br = Files.newBufferedReader(path);){
                String line = br.readLine();
                List<String> columns = Arrays.asList(line.split(","));
                if (columns.size() > 1) {
                    try {
                        result.put("unit", columns.get(3).split("_")[1].trim());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
                while ((line = br.readLine()) != null) {
                    columns = Arrays.asList(line.trim().split(","));
                    if (!columns.get(0).equals(input.getSpaceId())) continue;
                    ObjectNode lineObject = new ObjectNode(JsonNodeFactory.instance);
                    String years = columns.get(1).trim() + "-" + columns.get(2).trim();
                    lineObject.putArray(years);
                    ArrayNode lineMonthlyData = (ArrayNode)lineObject.get(years);
                    for (int i = 0; i < ncar.manager.util.Util.MONTHS_TITLES.length; ++i) {
                        ObjectNode monthObject = new ObjectNode(JsonNodeFactory.instance);
                        try {
                            double d = Double.parseDouble(columns.get(i + 3));
                            monthObject.put(ncar.manager.util.Util.MONTHS_TITLES[i], d);
                        }
                        catch (NumberFormatException nfe) {
                            monthObject.put(ncar.manager.util.Util.MONTHS_TITLES[i], "N/A");
                        }
                        lineMonthlyData.add((JsonNode)monthObject);
                    }
                    monthlyDecennial.add((JsonNode)lineObject);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        if (monthlyDecennial.size() == 0) {
            result.put("success", false);
            result.remove("monthlyDecennial");
            result.remove("labels");
            result.remove("unit");
        } else {
            this.prepareResponse(result, input);
        }
        return result;
    }

    private void prepareResponse(ObjectNode result, GraphingRequest input) {
        result.put("variable", input.getVariable());
        result.put("period", input.getPeriod());
        result.put("spaceId", input.getSpaceId());
        result.put("spatialId", input.getSpatialId());
        result.put("success", true);
    }

    public void verifyRequest(FilePathRequest request) throws InvalidRequestException {
        Util.verifyParameter((String)request.getFilePath());
        Util.verifyParameter((String)request.getLat());
        Util.verifyParameter((String)request.getLon());
        Util.verifyParameter((String)request.getTitle());
        Util.verifyParameter((String)request.getLayer());
        Util.verifyParameter((String)request.getTime());
        Util.verifyParameter((String)request.getAddPeriod());
        List<String> files = request.getOriginalFiles();
        for (String s : files) {
            Util.verifyParameter((String)s);
        }
    }

    public void verifyRequest(GraphingRequest request) throws InvalidRequestException {
        List<String> stat;
        Util.verifyParameter((String)request.getRcp());
        Util.verifyParameter((String)request.getSpaceId());
        Util.verifyParameter((String)request.getSpatialId());
        List<String> ens = request.getEnsMembers();
        if (ens != null) {
            for (String s : ens) {
                Util.verifyParameter((String)s);
            }
        }
        if ((stat = request.getStatistics()) != null) {
            for (String s : stat) {
                Util.verifyParameter((String)s);
            }
        }
    }
}

