/*
 * Decompiled with CFR 0.152.
 */
package ncar.manager.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ncar.manager.model.NetcdfAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.Index3D;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.geoloc.LatLonRect;

public class Util {
    public static final String TITLE = "title";
    public static final String UNITS = "units";
    public static final List<String> monthlyAbbv = Arrays.asList("jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec");
    public static final String[] MONTHS_TITLES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String VALID_MIN = "valid_min";
    private static final String VALID_MAX = "valid_max";
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private static final String CANT_FIND_VARIABLE_S_IN_FILE_S = "Can't find Variable %s in file %s";
    private static final String FILL_VALUE = "_FillValue";
    private static final String TIME = "time";
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetcdfAttributes getNetcdfVariableAttributes(String filename, String layerName, String aggregationPeriod) {
        NetcdfAttributes netcdfVariableAttributes;
        block51: {
            NetcdfFile ncfile = null;
            GridDataset gds = null;
            netcdfVariableAttributes = new NetcdfAttributes();
            try {
                Calendar cal;
                ncfile = NetcdfFile.open((String)filename);
                gds = GridDataset.open((String)filename);
                netcdfVariableAttributes.setBoundingBox(gds.getBoundingBox());
                Variable variable = ncfile.findVariable(layerName);
                if (variable == null) {
                    log.error(CANT_FIND_VARIABLE_S_IN_FILE_S, (Object)layerName, (Object)filename);
                } else {
                    List attributes = variable.getAttributes();
                    Object validMinAttr = null;
                    Object validMaxAttr = null;
                    Object titleAttr = null;
                    Object unitsAttr = null;
                    for (Object attribute : attributes) {
                        if (attribute.getFullName().contains(VALID_MIN)) {
                            validMinAttr = attribute;
                            continue;
                        }
                        if (attribute.getFullName().contains(VALID_MAX)) {
                            validMaxAttr = attribute;
                            continue;
                        }
                        if (attribute.getFullName().contains(TITLE) || attribute.getFullName().contains("long_name")) {
                            titleAttr = attribute;
                            continue;
                        }
                        if (!attribute.getFullName().contains(UNITS)) continue;
                        unitsAttr = attribute;
                    }
                    if (validMinAttr != null) {
                        netcdfVariableAttributes.setValidMin((Float)validMinAttr.getNumericValue());
                    }
                    if (validMaxAttr != null) {
                        netcdfVariableAttributes.setValidMax((Float)validMaxAttr.getNumericValue());
                    }
                    if (titleAttr != null) {
                        netcdfVariableAttributes.setTitle(titleAttr.getStringValue());
                    }
                    if (unitsAttr != null) {
                        netcdfVariableAttributes.setUnits(unitsAttr.getStringValue());
                    }
                }
                Variable time = ncfile.findVariable(TIME);
                List attributes = time.getAttributes();
                String units = "";
                String calendar = "365_day";
                for (Attribute attribute : attributes) {
                    if (attribute.getFullName().contains(UNITS)) {
                        units = attribute.getStringValue();
                    }
                    if (!attribute.getFullName().contains("calendar")) continue;
                    calendar = attribute.getStringValue();
                }
                switch (calendar) {
                    case "365_day": 
                    case "noleap": {
                        cal = Calendar.noleap;
                        break;
                    }
                    case "gregorian": 
                    case "standard": {
                        cal = Calendar.gregorian;
                        break;
                    }
                    case "julian": {
                        cal = Calendar.julian;
                        break;
                    }
                    case "all_leap": 
                    case "366_day": {
                        cal = Calendar.all_leap;
                        break;
                    }
                    case "uniform30day": 
                    case "360_day": {
                        cal = Calendar.uniform30day;
                        break;
                    }
                    default: {
                        cal = Calendar.none;
                    }
                }
                CalendarDateUnit cdu = CalendarDateUnit.withCalendar((Calendar)cal, (String)units);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                int aggPeriodIndex = monthlyAbbv.indexOf(aggregationPeriod);
                Array data = time.read();
                int size = time.getDimension(0).getLength();
                if (size == 1) {
                    CalendarDate calendarDate = cdu.makeCalendarDate((double)data.getFloat(0));
                    LocalDate localDate = Instant.ofEpochMilli(calendarDate.getMillis()).atZone(ZoneId.of("UTC")).toLocalDate();
                    netcdfVariableAttributes.setTime(localDate.format(formatter));
                    break block51;
                }
                for (int i = 0; i < size; ++i) {
                    CalendarDate calendarDate = cdu.makeCalendarDate((double)data.getFloat(i));
                    int month = calendarDate.getFieldValue(CalendarPeriod.Field.Month) - 1;
                    if (month != aggPeriodIndex) continue;
                    LocalDate localDate = Instant.ofEpochMilli(calendarDate.getMillis()).atZone(ZoneId.of("UTC")).toLocalDate();
                    netcdfVariableAttributes.setTime(localDate.format(formatter));
                    break;
                }
            }
            catch (IOException ioe) {
                log.error(String.format("Error reading file %s", filename));
            }
            finally {
                if (null != ncfile) {
                    try {
                        ncfile.close();
                    }
                    catch (IOException ioe) {
                        log.error(ioe.getMessage());
                    }
                }
                if (null != gds) {
                    try {
                        gds.close();
                    }
                    catch (IOException e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
        return netcdfVariableAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetcdfAttributes createDifferenceFile(String filePath1, String layerName1, String aggPeriod1, String filePath2, String layerName2, String aggPeriod2, String filePath) {
        Instant start = Instant.now();
        NetcdfAttributes netcdfAttributes = new NetcdfAttributes();
        NetcdfFile dataFile1 = null;
        NetcdfFile dataFile2 = null;
        GridDataset gds = null;
        try {
            boolean isInitialised;
            dataFile1 = NetcdfFile.open((String)filePath1, null);
            dataFile2 = NetcdfFile.open((String)filePath2, null);
            Variable varFromFile1 = dataFile1.findVariable(layerName1);
            if (varFromFile1 == null) {
                throw new Exception("Can't read originalVar " + layerName1 + " from file " + filePath1);
            }
            Variable varFromFile2 = dataFile2.findVariable(layerName2);
            if (varFromFile2 == null) {
                throw new Exception("Can't read originalVar " + layerName2 + " from file " + filePath2);
            }
            float fillVal1 = Util.getNumericAttribute(varFromFile1, FILL_VALUE);
            float fillVal2 = Util.getNumericAttribute(varFromFile2, FILL_VALUE);
            float missingVal1 = Util.getNumericAttribute(varFromFile1, "missing_value");
            float missingVal2 = Util.getNumericAttribute(varFromFile2, "missing_value");
            float validMax1 = Util.getNumericAttribute(varFromFile1, VALID_MAX);
            float validMax2 = Util.getNumericAttribute(varFromFile2, VALID_MAX);
            float validMin1 = Util.getNumericAttribute(varFromFile1, VALID_MIN);
            float validMin2 = Util.getNumericAttribute(varFromFile2, VALID_MIN);
            ArrayFloat.D3 var1Values = (ArrayFloat.D3)varFromFile1.read();
            ArrayFloat.D3 var2Values = (ArrayFloat.D3)varFromFile2.read();
            List var1Dimensions = varFromFile1.getDimensions();
            List var2Dimensions = varFromFile2.getDimensions();
            if (var1Dimensions.size() != var2Dimensions.size()) {
                throw new Exception("Variables " + layerName1 + " and " + layerName2 + " have different dimensions");
            }
            int columns1 = -1;
            int rows1 = -1;
            int columns2 = -1;
            int rows2 = -1;
            for (Dimension dimension : var1Dimensions) {
                if (dimension.getShortName().equals(LATITUDE)) {
                    columns1 = dimension.getLength();
                    continue;
                }
                if (!dimension.getShortName().equals(LONGITUDE)) continue;
                rows1 = dimension.getLength();
            }
            for (Dimension dimension : var2Dimensions) {
                if (dimension.getShortName().equals(LATITUDE)) {
                    columns2 = dimension.getLength();
                    continue;
                }
                if (!dimension.getShortName().equals(LONGITUDE)) continue;
                rows2 = dimension.getLength();
            }
            boolean bl = isInitialised = columns1 > 0 && rows1 > 0 && columns2 > 0 && rows2 > 0;
            if (!isInitialised || columns1 != columns2 || rows1 != rows2) {
                throw new Exception("Variables " + layerName1 + " and " + layerName2 + " don't have correct dimensions");
            }
            float[][] resultArr = new float[columns1][rows1];
            int index1 = ((Dimension)var1Dimensions.get(0)).getLength() == 1 ? 0 : monthlyAbbv.indexOf(aggPeriod1);
            int index2 = ((Dimension)var2Dimensions.get(0)).getLength() == 1 ? 0 : monthlyAbbv.indexOf(aggPeriod2);
            for (int i = 0; i < columns1; ++i) {
                for (int j = 0; j < rows1; ++j) {
                    boolean isValid1 = !(Float.compare(var1Values.get(index1, i, j), fillVal1) == 0 || Float.compare(var1Values.get(index1, i, j), missingVal1) == 0 || !Float.isNaN(validMin1) && Float.compare(var1Values.get(index1, i, j), validMin1) < 0 || !Float.isNaN(validMax1) && Float.compare(var1Values.get(index1, i, j), validMax1) > 0);
                    boolean isValid2 = !(Float.compare(var2Values.get(index2, i, j), fillVal2) == 0 || Float.compare(var1Values.get(index2, i, j), missingVal2) == 0 || !Float.isNaN(validMin2) && Float.compare(var2Values.get(index2, i, j), validMin2) < 0 || !Float.isNaN(validMax2) && Float.compare(var2Values.get(index2, i, j), validMax2) > 0);
                    resultArr[i][j] = isValid1 && isValid2 ? var1Values.get(index1, i, j) - var2Values.get(index2, i, j) : Float.NaN;
                }
            }
            netcdfAttributes = Util.createNetcdfFile(varFromFile1, dataFile1.findVariable(TIME), dataFile1.findVariable(LATITUDE), dataFile1.findVariable(LONGITUDE), resultArr, filePath);
            gds = GridDataset.open((String)filePath1);
            netcdfAttributes.setBoundingBox(gds.getBoundingBox());
            Instant end = Instant.now();
            Duration timeElapsed = Duration.between(start, end);
            String message = "Calculate Difference time ( milliseconds ):" + timeElapsed.toMillis();
            log.info(message);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        finally {
            if (dataFile1 != null) {
                try {
                    dataFile1.close();
                }
                catch (IOException ioe) {
                    log.error(ioe.toString());
                }
            }
            if (dataFile2 != null) {
                try {
                    dataFile2.close();
                }
                catch (IOException ioe) {
                    log.error(ioe.toString());
                }
            }
            if (gds != null) {
                try {
                    gds.close();
                }
                catch (IOException e) {
                    log.error(e.toString());
                }
            }
        }
        return netcdfAttributes;
    }

    private static float getNumericAttribute(Variable variable, String name) {
        float fillVal1 = Float.NaN;
        try {
            List attributes = variable.getAttributes();
            for (Attribute attribute : attributes) {
                if (!attribute.getFullName().contains(name)) continue;
                fillVal1 = attribute.getNumericValue().floatValue();
                break;
            }
        }
        catch (NullPointerException e) {
            log.error(e.getMessage());
        }
        return fillVal1;
    }

    private static String formatUnitHtml(String unit) {
        String htmlFormattedUnit = unit;
        if (unit.contains("degrees")) {
            htmlFormattedUnit = htmlFormattedUnit.replaceAll("degrees", "&deg;");
        } else if (htmlFormattedUnit.contains("deg")) {
            htmlFormattedUnit = htmlFormattedUnit.replaceAll("deg", "&deg;");
        } else if (htmlFormattedUnit.startsWith("days")) {
            htmlFormattedUnit = "days";
        }
        return htmlFormattedUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NetcdfAttributes createNetcdfFile(Variable originalVar, Variable timeVar, Variable latVar, Variable lonVar, float[][] resultArr, String filePath) {
        NetcdfFileWriter dataFile = null;
        NetcdfAttributes netcdfAttributes = new NetcdfAttributes();
        netcdfAttributes.setValidMax(Float.valueOf(Float.NaN));
        netcdfAttributes.setValidMin(Float.valueOf(Float.NaN));
        netcdfAttributes.setFileName(System.currentTimeMillis() + ".nc");
        netcdfAttributes.setLayer(originalVar.findAttribute("VarName").getStringValue() + "_diff");
        try {
            dataFile = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)(filePath + netcdfAttributes.getFileName()));
            Dimension timeDim = dataFile.addUnlimitedDimension(TIME);
            Dimension latDim = null;
            Dimension lonDim = null;
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            dims.add(timeDim);
            for (Dimension dimension : originalVar.getDimensions()) {
                if (dimension.getShortName().equals(LATITUDE)) {
                    latDim = dataFile.addDimension(null, LATITUDE, dimension.getLength());
                    continue;
                }
                if (!dimension.getShortName().equals(LONGITUDE)) continue;
                lonDim = dataFile.addDimension(null, LONGITUDE, dimension.getLength());
            }
            dims.add(latDim);
            dims.add(lonDim);
            Variable vlat = dataFile.addVariable(null, LATITUDE, DataType.FLOAT, LATITUDE);
            Variable vlon = dataFile.addVariable(null, LONGITUDE, DataType.FLOAT, LONGITUDE);
            vlat.addAttribute(latVar.findAttribute(UNITS));
            vlon.addAttribute(lonVar.findAttribute(UNITS));
            int[] iDim = new int[]{1, latDim.getLength(), lonDim.getLength()};
            Array data = Array.factory((DataType)DataType.FLOAT, (int[])iDim);
            Index3D idx = new Index3D(iDim);
            float max = Float.NaN;
            float min = Float.NaN;
            for (int i = 0; i < latDim.getLength(); ++i) {
                for (int j = 0; j < lonDim.getLength(); ++j) {
                    idx.set(0, i, j);
                    if (!Float.isNaN(resultArr[i][j])) {
                        if (Float.isNaN(min) || resultArr[i][j] < min) {
                            min = resultArr[i][j];
                        }
                        if (Float.isNaN(max) || resultArr[i][j] > max) {
                            max = resultArr[i][j];
                        }
                    }
                    data.setFloat((Index)idx, resultArr[i][j]);
                }
            }
            List attrs = originalVar.getAttributes();
            Variable vtime = dataFile.addVariable(null, TIME, timeVar.getDataType(), TIME);
            Variable var = dataFile.addVariable(null, netcdfAttributes.getLayer(), DataType.FLOAT, dims);
            attrs.forEach(arg_0 -> ((Variable)var).addAttribute(arg_0));
            attrs = timeVar.getAttributes();
            attrs.forEach(arg_0 -> ((Variable)vtime).addAttribute(arg_0));
            var.addAttribute(new Attribute(VALID_MIN, (Number)Float.valueOf(min)));
            var.addAttribute(new Attribute(VALID_MAX, (Number)Float.valueOf(max)));
            int[] origin = new int[3];
            dataFile.create();
            dataFile.write(vlat, latVar.read());
            dataFile.write(vlon, lonVar.read());
            dataFile.write(var, origin, data);
            netcdfAttributes.setUnits(Util.formatUnitHtml(var.findAttribute(UNITS).getStringValue()));
            netcdfAttributes.setValidMax(Float.valueOf(max));
            netcdfAttributes.setValidMin(Float.valueOf(min));
        }
        catch (IOException | NullPointerException | InvalidRangeException e) {
            netcdfAttributes.setFileName(null);
            log.error(e.getMessage());
        }
        finally {
            if (null != dataFile) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    log.error(ioe.toString());
                }
            }
        }
        return netcdfAttributes;
    }

    public static void main(String[] args) {
        ArrayList<String> field = new ArrayList<String>();
        field.add("Rime_Factor_isobaric");
        Map<String, List<Float>> map = Util.getDataForFieldsFromFile(field, "/Users/tatiana/Downloads/2015102712.grb", Float.valueOf(40.0f), Float.valueOf(-100.0f), null);
        GridDataset gds = null;
        try {
            gds = GridDataset.open((String)"/Users/tatiana/Downloads/2015102712.grb");
            LatLonRect latLonRect = gds.getBoundingBox();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, List<Float>> getDataForFieldsFromFile(List<String> fields, String path, Float lat, Float lon, String aggPeriod) {
        GridDataset gds = null;
        HashMap<String, List<Float>> result = new HashMap<String, List<Float>>();
        try {
            gds = GridDataset.open((String)path);
            for (String field : fields) {
                GridCoordSystem gcs;
                int[] xy;
                GridDatatype grid = gds.findGridDatatype(field);
                if (grid == null) {
                    field = gds.getName().split("_")[0];
                    grid = gds.findGridDatatype(field);
                }
                if ((xy = (gcs = grid.getCoordinateSystem()).findXYindexFromLatLon((double)lat.floatValue(), (double)lon.floatValue(), null))[0] < 0 || xy[1] < 0) continue;
                ArrayList<Float> data = new ArrayList<Float>();
                if (aggPeriod != null) {
                    int index = grid.getDimensions().size() == 1 ? 0 : monthlyAbbv.indexOf(aggPeriod);
                    data.add(Float.valueOf(grid.readDataSlice(index, 0, xy[1], xy[0]).getFloat(0)));
                } else {
                    for (int i = 0; i < grid.getDimension(0).getLength(); ++i) {
                        data.add(Float.valueOf(grid.readDataSlice(i, 0, xy[1], xy[0]).getFloat(0)));
                    }
                }
                result.put(field, data);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        finally {
            if (gds != null) {
                try {
                    gds.close();
                }
                catch (IOException e) {
                    log.error(e.toString());
                }
            }
        }
        return result;
    }

    public static JsonNode convertListToJsonArray(List<String> stringList) {
        ArrayNode jsonArray = new ArrayNode(JsonNodeFactory.instance);
        if (stringList != null) {
            stringList.forEach(arg_0 -> ((ArrayNode)jsonArray).add(arg_0));
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getDataUsingLatLon(String filePath, String layerName, Float lat, Float lon) {
        Float result = null;
        GridDataset gds = null;
        try {
            gds = GridDataset.open((String)filePath);
            GridDatatype grid = gds.findGridDatatype(layerName);
            GridCoordSystem gcs = grid.getCoordinateSystem();
            int[] xy = gcs.findXYindexFromLatLon((double)lat.floatValue(), (double)lon.floatValue(), null);
            if (xy[0] >= 0 && xy[1] >= 0) {
                Array data = grid.readDataSlice(0, 0, xy[1], xy[0]);
                result = Float.valueOf(data.getFloat(0));
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        finally {
            if (gds != null) {
                try {
                    gds.close();
                }
                catch (IOException e) {
                    log.error(e.toString());
                }
            }
        }
        return result;
    }
}

