/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.jcip.annotations.Immutable;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilder;
import ucar.coord.CoordinateBuilderImpl;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateTime2D
extends CoordinateTimeAbstract
implements Coordinate {
    private final CoordinateRuntime runtime;
    private final List<Coordinate> times;
    private final CoordinateTimeAbstract otime;
    private final SortedMap<Integer, CoordinateTimeAbstract> regTimes;
    private final int[] offset;
    private final boolean isRegular;
    private final boolean isOrthogonal;
    private final boolean isTimeInterval;
    private final int nruns;
    private final int ntimes;
    private final List<Time2D> vals;

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, List<Time2D> vals, CoordinateRuntime runtime, List<Coordinate> times) {
        super(code, timeUnit, runtime.getFirstDate(), null);
        this.runtime = runtime;
        this.times = Collections.unmodifiableList(times);
        this.otime = null;
        this.regTimes = null;
        this.isRegular = false;
        this.isOrthogonal = false;
        this.isTimeInterval = times.get(0) instanceof CoordinateTimeIntv;
        int nmax = 0;
        for (Coordinate time : times) {
            nmax = Math.max(nmax, time.getSize());
        }
        this.ntimes = nmax;
        this.nruns = runtime.getSize();
        assert (this.nruns == times.size());
        this.offset = this.makeOffsets(times);
        this.vals = vals == null ? null : Collections.unmodifiableList(vals);
    }

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, List<Time2D> vals, CoordinateRuntime runtime, CoordinateTimeAbstract otime, List<Coordinate> times) {
        super(code, timeUnit, runtime.getFirstDate(), null);
        this.runtime = runtime;
        this.times = times == null ? null : Collections.unmodifiableList(times);
        this.otime = otime;
        this.isOrthogonal = true;
        this.isRegular = false;
        this.regTimes = null;
        this.isTimeInterval = otime instanceof CoordinateTimeIntv;
        this.ntimes = otime.getSize();
        this.nruns = runtime.getSize();
        this.offset = this.makeOffsets(timeUnit);
        this.vals = vals == null ? null : Collections.unmodifiableList(vals);
    }

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, List<Time2D> vals, CoordinateRuntime runtime, List<Coordinate> regList, List<Coordinate> times) {
        super(code, timeUnit, runtime.getFirstDate(), null);
        this.runtime = runtime;
        this.nruns = runtime.getSize();
        this.times = times == null ? null : Collections.unmodifiableList(times);
        this.otime = null;
        this.isOrthogonal = false;
        this.isRegular = true;
        CoordinateTimeAbstract first = (CoordinateTimeAbstract)regList.get(0);
        this.isTimeInterval = first instanceof CoordinateTimeIntv;
        int nmax = 0;
        for (Coordinate time : regList) {
            nmax = Math.max(nmax, time.getSize());
        }
        this.ntimes = nmax;
        this.regTimes = new TreeMap<Integer, CoordinateTimeAbstract>();
        for (Coordinate coord : regList) {
            CoordinateTimeAbstract time = (CoordinateTimeAbstract)coord;
            CalendarDate ref = time.getRefDate();
            int hour = ref.getHourOfDay();
            this.regTimes.put(hour, time);
        }
        this.offset = this.makeOffsets(timeUnit);
        this.vals = vals == null ? null : Collections.unmodifiableList(vals);
    }

    private int[] makeOffsets(List<Coordinate> orgTimes) {
        CalendarDate firstDate = this.runtime.getFirstDate();
        int[] offsets = new int[this.nruns];
        for (int idx = 0; idx < this.nruns; ++idx) {
            CoordinateTimeAbstract coordTime = (CoordinateTimeAbstract)orgTimes.get(idx);
            CalendarPeriod period = coordTime.getPeriod();
            offsets[idx] = period.getOffset(firstDate, this.runtime.getRuntimeDate(idx));
        }
        return offsets;
    }

    private int[] makeOffsets(CalendarPeriod period) {
        CalendarDate firstDate = this.runtime.getFirstDate();
        int[] offsets = new int[this.nruns];
        for (int idx = 0; idx < this.nruns; ++idx) {
            offsets[idx] = period.getOffset(firstDate, this.runtime.getRuntimeDate(idx));
        }
        return offsets;
    }

    public CoordinateRuntime getRuntimeCoordinate() {
        return this.runtime;
    }

    public boolean isTimeInterval() {
        return this.isTimeInterval;
    }

    public boolean isOrthogonal() {
        return this.isOrthogonal;
    }

    public boolean isRegular() {
        return this.isRegular;
    }

    public int getNtimes() {
        return this.ntimes;
    }

    public int getNruns() {
        return this.nruns;
    }

    public int getOffset(int runIndex) {
        return this.offset[runIndex];
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s nruns=%d ntimes=%d isOrthogonal=%s isRegular=%s%n", this.name, this.nruns, this.ntimes, this.isOrthogonal, this.isRegular);
        this.runtime.showInfo(info, indent);
        indent.incr();
        info.format("%nAll time values=", new Object[0]);
        List<? extends Object> timeValues = this.getOffsetsSorted();
        for (Object object : timeValues) {
            info.format(" %s,", object);
        }
        info.format(" (n=%d)%n%n", timeValues.size());
        if (this.isOrthogonal) {
            this.otime.showInfo(info, indent);
        } else if (this.isRegular) {
            Iterator<? extends Object> iterator = this.regTimes.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                CoordinateTimeAbstract timeCoord = (CoordinateTimeAbstract)this.regTimes.get(n);
                info.format("%shour %d: ", indent, n);
                timeCoord.showInfo(info, new Indent(0));
            }
        } else {
            for (Coordinate coordinate : this.times) {
                info.format("%s%s:", indent, ((CoordinateTimeAbstract)coordinate).getRefDate());
                coordinate.showInfo(info, new Indent(0));
            }
        }
        indent.decr();
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("%s nruns=%d ntimes=%d isOrthogonal=%s isRegular=%s%n", this.name, this.nruns, this.ntimes, this.isOrthogonal, this.isRegular);
        this.runtime.showCoords(info);
        if (this.isOrthogonal) {
            this.otime.showCoords(info);
        } else if (this.isRegular) {
            for (int hour : this.regTimes.keySet()) {
                CoordinateTimeAbstract timeCoord = (CoordinateTimeAbstract)this.regTimes.get(hour);
                info.format("hour %d: ", hour);
                timeCoord.showInfo(info, new Indent(0));
            }
        } else {
            for (Coordinate time : this.times) {
                time.showCoords(info);
            }
        }
    }

    @Override
    public List<? extends Object> getValues() {
        return this.vals;
    }

    @Override
    public Object getValue(int idx) {
        return this.vals == null ? null : this.vals.get(idx);
    }

    @Override
    public int getIndex(Object val) {
        return this.vals == null ? -1 : Collections.binarySearch(this.vals, (Time2D)val);
    }

    @Override
    public int getSize() {
        return this.vals == null ? 0 : this.vals.size();
    }

    @Override
    public int estMemorySize() {
        return 864 + this.nruns * 52 + this.ntimes * 24;
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.time2D;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateTime2D that = (CoordinateTime2D)o;
        if (this.isTimeInterval != that.isTimeInterval) {
            return false;
        }
        if (!this.runtime.equals(that.runtime)) {
            return false;
        }
        if (this.isOrthogonal != that.isOrthogonal) {
            return false;
        }
        if (this.isRegular != that.isRegular) {
            return false;
        }
        if (this.otime != null ? !this.otime.equals(that.otime) : that.otime != null) {
            return false;
        }
        if (this.regTimes != null ? !this.regTimes.equals(that.regTimes) : that.regTimes != null) {
            return false;
        }
        return !(this.times != null ? !this.times.equals(that.times) : that.times != null);
    }

    public int hashCode() {
        int result = this.runtime.hashCode();
        result = 31 * result + (this.times != null ? this.times.hashCode() : 0);
        result = 31 * result + (this.otime != null ? this.otime.hashCode() : 0);
        result = 31 * result + (this.regTimes != null ? this.regTimes.hashCode() : 0);
        result = 31 * result + (this.isRegular ? 1 : 0);
        result = 31 * result + (this.isOrthogonal ? 1 : 0);
        result = 31 * result + (this.isTimeInterval ? 1 : 0);
        return result;
    }

    public String getTimeIntervalName() {
        if (!this.isTimeInterval) {
            return null;
        }
        if (this.isOrthogonal) {
            return ((CoordinateTimeIntv)this.otime).getTimeIntervalName();
        }
        if (this.isRegular) {
            String firstValue = null;
            for (CoordinateTimeAbstract timeCoord : this.regTimes.values()) {
                CoordinateTimeIntv timeCoordi = (CoordinateTimeIntv)timeCoord;
                String value = timeCoordi.getTimeIntervalName();
                if (firstValue == null) {
                    firstValue = value;
                    continue;
                }
                if (!value.equals(firstValue)) {
                    return "Mixed_intervals";
                }
                if (!value.equals("Mixed_intervals")) continue;
                return "Mixed_intervals";
            }
            return firstValue;
        }
        String firstValue = null;
        for (Coordinate timeCoord : this.times) {
            if (this.times.size() == 0) continue;
            CoordinateTimeIntv timeCoordi = (CoordinateTimeIntv)timeCoord;
            String value = timeCoordi.getTimeIntervalName();
            if (firstValue == null) {
                firstValue = value;
                continue;
            }
            if (!value.equals(firstValue)) {
                return "Mixed_intervals";
            }
            if (!value.equals("Mixed_intervals")) continue;
            return "Mixed_intervals";
        }
        return firstValue;
    }

    @Override
    public CalendarDateRange makeCalendarDateRange(Calendar cal) {
        CoordinateTimeAbstract firstCoord = this.getTimeCoordinate(0);
        CoordinateTimeAbstract lastCoord = this.getTimeCoordinate(this.nruns - 1);
        CalendarDateRange firstRange = firstCoord.makeCalendarDateRange(cal);
        CalendarDateRange lastRange = lastCoord.makeCalendarDateRange(cal);
        return CalendarDateRange.of(firstRange.getStart(), lastRange.getEnd());
    }

    public CoordinateTimeAbstract getTimeCoordinate(int runIdx) {
        if (this.isOrthogonal) {
            return this.factory(this.otime, this.getRefDate(runIdx));
        }
        if (this.isRegular) {
            CalendarDate ref = this.getRefDate(runIdx);
            int hour = ref.getHourOfDay();
            return (CoordinateTimeAbstract)this.regTimes.get(hour);
        }
        return (CoordinateTimeAbstract)this.times.get(runIdx);
    }

    public CalendarDate getRefDate(int runIdx) {
        return this.runtime.getRuntimeDate(runIdx);
    }

    public long getRuntime(int runIdx) {
        return this.runtime.getRuntime(runIdx);
    }

    private CoordinateTimeAbstract factory(CoordinateTimeAbstract org, CalendarDate refDate) {
        if (this.isTimeInterval) {
            return new CoordinateTimeIntv((CoordinateTimeIntv)org, refDate);
        }
        return new CoordinateTime((CoordinateTime)org, refDate);
    }

    public Time2D getOrgValue(int runIdx, int timeIdx, boolean debug) {
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        CalendarDate runDate = this.runtime.getRuntimeDate(runIdx);
        if (this.isTimeInterval) {
            TimeCoord.Tinv valIntv = (TimeCoord.Tinv)time.getValue(timeIdx);
            if (valIntv == null) {
                return null;
            }
            return new Time2D(runDate, null, valIntv);
        }
        Integer val = (Integer)time.getValue(timeIdx);
        if (val == null) {
            return null;
        }
        return new Time2D(runDate, val, null);
    }

    public boolean getIndex(Time2D want, int[] wholeIndex) {
        int runIdx = this.runtime.getIndex(want.run);
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        wholeIndex[0] = runIdx;
        wholeIndex[1] = this.isTimeInterval ? time.getIndex(want.tinv) : time.getIndex(want.time);
        return wholeIndex[0] >= 0 && wholeIndex[1] >= 0;
    }

    public int matchTimeCoordinate(int runIdx, Object value, CalendarDate refDateOfValue) {
        Comparable<TimeCoord.Tinv> valueWithOffset;
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        int offset = this.timeUnit.getOffset(this.getRefDate(runIdx), refDateOfValue);
        if (this.isTimeInterval) {
            TimeCoord.Tinv tinv = (TimeCoord.Tinv)value;
            valueWithOffset = tinv.offset(offset);
        } else {
            Integer val = (Integer)value;
            valueWithOffset = val + offset;
        }
        int result = time.getIndex(valueWithOffset);
        if (GribIosp.debugRead) {
            System.out.printf("  matchTimeCoordinate value wanted = (%s) valueWithOffset=%s result=%d %n", value, valueWithOffset, result);
        }
        return result;
    }

    @Override
    protected CoordinateTimeAbstract makeBestFromComplete(int[] best, int n) {
        throw new UnsupportedOperationException();
    }

    public CoordinateTimeAbstract makeBestTimeCoordinate(CoordinateRuntime master) {
        if (this.isTimeInterval) {
            return this.makeBestTimeIntv(master);
        }
        return this.makeBestTime(master);
    }

    /*
     * WARNING - void declaration
     */
    private CoordinateTimeAbstract makeBestTime(CoordinateRuntime master) {
        HashSet<Integer> values = new HashSet<Integer>();
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTime timeCoord = this.times == null ? (CoordinateTime)this.getTimeCoordinate(runIdx) : (CoordinateTime)this.times.get(runIdx);
            for (Integer n : timeCoord.getOffsetSorted()) {
                values.add(n + this.getOffset(runIdx));
            }
        }
        ArrayList<Integer> offsetSorted = new ArrayList<Integer>(values.size());
        for (Object e : values) {
            offsetSorted.add((Integer)e);
        }
        Collections.sort(offsetSorted);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        boolean bl = false;
        for (Integer val : offsetSorted) {
            void var5_10;
            map.put(val, (int)(++var5_10));
        }
        int[] nArray = new int[this.nruns];
        int masterIdx = 0;
        for (int run2Didx = 0; run2Didx < this.nruns; ++run2Didx) {
            while (!master.getRuntimeDate(masterIdx).equals(this.runtime.getRuntimeDate(run2Didx))) {
                ++masterIdx;
            }
            nArray[run2Didx] = masterIdx++;
        }
        assert (masterIdx >= this.nruns);
        int[] time2runtime = new int[offsetSorted.size()];
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTime timeCoord = this.times == null ? (CoordinateTime)this.getTimeCoordinate(runIdx) : (CoordinateTime)this.times.get(runIdx);
            for (Integer offset : timeCoord.getOffsetSorted()) {
                Integer bestValIdx = (Integer)map.get(offset + this.getOffset(runIdx));
                if (bestValIdx == null) {
                    throw new IllegalStateException();
                }
                time2runtime[bestValIdx.intValue()] = nArray[runIdx] + 1;
            }
        }
        return new CoordinateTime(this.getCode(), this.getTimeUnit(), this.getRefDate(), offsetSorted, time2runtime);
    }

    /*
     * WARNING - void declaration
     */
    private CoordinateTimeAbstract makeBestTimeIntv(CoordinateRuntime master) {
        HashSet<TimeCoord.Tinv> values = new HashSet<TimeCoord.Tinv>();
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTimeIntv timeIntv = this.times == null ? (CoordinateTimeIntv)this.getTimeCoordinate(runIdx) : (CoordinateTimeIntv)this.times.get(runIdx);
            for (TimeCoord.Tinv tinv : timeIntv.getTimeIntervals()) {
                values.add(tinv.offset(this.getOffset(runIdx)));
            }
        }
        ArrayList<TimeCoord.Tinv> offsetSorted = new ArrayList<TimeCoord.Tinv>(values.size());
        for (Object e : values) {
            offsetSorted.add((TimeCoord.Tinv)e);
        }
        Collections.sort(offsetSorted);
        HashMap<TimeCoord.Tinv, Integer> map = new HashMap<TimeCoord.Tinv, Integer>();
        boolean bl = false;
        for (TimeCoord.Tinv val : offsetSorted) {
            void var5_10;
            map.put(val, (int)(++var5_10));
        }
        int[] nArray = new int[this.nruns];
        int masterIdx = 0;
        for (int run2Didx = 0; run2Didx < this.nruns; ++run2Didx) {
            while (!master.getRuntimeDate(masterIdx).equals(this.runtime.getRuntimeDate(run2Didx))) {
                ++masterIdx;
            }
            nArray[run2Didx] = masterIdx++;
        }
        assert (masterIdx >= this.nruns);
        int[] time2runtime = new int[offsetSorted.size()];
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTimeIntv timeIntv = this.times == null ? (CoordinateTimeIntv)this.getTimeCoordinate(runIdx) : (CoordinateTimeIntv)this.times.get(runIdx);
            for (TimeCoord.Tinv bestVal : timeIntv.getTimeIntervals()) {
                Integer bestValIdx = (Integer)map.get(bestVal.offset(this.getOffset(runIdx)));
                if (bestValIdx == null) {
                    throw new IllegalStateException();
                }
                time2runtime[bestValIdx.intValue()] = nArray[runIdx] + 1;
            }
        }
        return new CoordinateTimeIntv(this.getCode(), this.getTimeUnit(), this.getRefDate(), offsetSorted, time2runtime);
    }

    public List<? extends Coordinate> getTimesForSerialization() {
        if (this.isOrthogonal) {
            ArrayList<CoordinateTimeAbstract> list = new ArrayList<CoordinateTimeAbstract>(1);
            list.add(this.otime);
            return list;
        }
        if (this.isRegular) {
            return new ArrayList<CoordinateTimeAbstract>(this.regTimes.values());
        }
        return this.times;
    }

    public List<? extends Object> getOffsetsSorted() {
        List<Coordinate> coords;
        if (this.isOrthogonal) {
            return this.otime.getValues();
        }
        List<Coordinate> list = coords = this.isRegular ? new ArrayList<CoordinateTimeAbstract>(this.regTimes.values()) : this.times;
        if (this.isTimeInterval) {
            return this.getIntervalsSorted(coords);
        }
        return this.getIntegersSorted(coords);
    }

    private List<Integer> getIntegersSorted(List<? extends Coordinate> coords) {
        HashSet<Integer> set = new HashSet<Integer>(100);
        for (Coordinate coordinate : coords) {
            for (Object object : coordinate.getValues()) {
                set.add((Integer)object);
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer val : set) {
            result.add(val);
        }
        Collections.sort(result);
        return result;
    }

    private List<TimeCoord.Tinv> getIntervalsSorted(List<? extends Coordinate> coords) {
        HashSet<TimeCoord.Tinv> set = new HashSet<TimeCoord.Tinv>(100);
        for (Coordinate coordinate : coords) {
            for (Object object : coordinate.getValues()) {
                set.add((TimeCoord.Tinv)object);
            }
        }
        ArrayList<TimeCoord.Tinv> result = new ArrayList<TimeCoord.Tinv>();
        for (TimeCoord.Tinv val : set) {
            result.add(val);
        }
        Collections.sort(result);
        return result;
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record>
    implements CoordinateBuilder.TwoD<Grib1Record> {
        private final boolean isTimeInterval;
        private final Grib1Customizer cust;
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CoordinateRuntime.Builder1 runBuilder;
        private final Map<Object, CoordinateBuilderImpl<Grib1Record>> timeBuilders;

        public Builder1(boolean isTimeInterval, Grib1Customizer cust, CalendarPeriod timeUnit, int code) {
            this.isTimeInterval = isTimeInterval;
            this.cust = cust;
            this.timeUnit = timeUnit;
            this.code = code;
            this.runBuilder = new CoordinateRuntime.Builder1(timeUnit);
            this.timeBuilders = new HashMap<Object, CoordinateBuilderImpl<Grib1Record>>();
        }

        @Override
        public void addRecord(Grib1Record gr) {
            super.addRecord(gr);
            this.runBuilder.addRecord(gr);
            Time2D val = (Time2D)this.extract(gr);
            CoordinateBuilderImpl<Grib1Record> timeBuilder = this.timeBuilders.get(val.run);
            timeBuilder.addRecord(gr);
        }

        @Override
        public Object extract(Grib1Record gr) {
            Object time;
            Long run = (Long)this.runBuilder.extract(gr);
            CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(run);
            if (timeBuilder == null) {
                timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder1(this.cust, this.code, this.timeUnit, CalendarDate.of(run)) : new CoordinateTime.Builder1(this.cust, this.code, this.timeUnit, CalendarDate.of(run));
                this.timeBuilders.put(run, timeBuilder);
            }
            if ((time = timeBuilder.extract((Grib1Record)gr)) instanceof Integer) {
                return new Time2D(run, (Integer)time, null);
            }
            return new Time2D(run, null, (TimeCoord.Tinv)time);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            CoordinateRuntime runCoord = (CoordinateRuntime)this.runBuilder.finish();
            ArrayList<Coordinate> times = new ArrayList<Coordinate>(runCoord.getSize());
            for (int idx = 0; idx < runCoord.getSize(); ++idx) {
                Long runtime = runCoord.getRuntime(idx);
                CoordinateBuilderImpl<Grib1Record> timeBuilder = this.timeBuilders.get(runtime);
                times.add(timeBuilder.finish());
            }
            ArrayList<Time2D> vals = new ArrayList<Time2D>(values.size());
            for (Object val : values) {
                vals.add((Time2D)val);
            }
            Collections.sort(vals);
            return new CoordinateTime2D(this.code, this.timeUnit, vals, runCoord, times);
        }

        @Override
        public void addAll(Coordinate coord) {
            super.addAll(coord);
            for (Object object : coord.getValues()) {
                Time2D val2D = (Time2D)object;
                this.runBuilder.add(val2D.run);
                CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(val2D.run);
                if (timeBuilder == null) {
                    timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder1(this.cust, this.code, this.timeUnit, val2D.getRefDate()) : new CoordinateTime.Builder1(this.cust, this.code, this.timeUnit, val2D.getRefDate());
                    this.timeBuilders.put(val2D.run, timeBuilder);
                }
                timeBuilder.add(this.isTimeInterval ? val2D.tinv : val2D.time);
            }
        }

        @Override
        public int[] getCoordIndices(Grib1Record gr) {
            CoordinateTime2D coord2D = (CoordinateTime2D)this.coord;
            Long run = (Long)this.runBuilder.extract(gr);
            int runIdx = coord2D.runtime.getIndex(run);
            CoordinateTimeAbstract timeCoord = coord2D.getTimeCoordinate(runIdx);
            CoordinateBuilderImpl<Grib1Record> timeBuilder = this.timeBuilders.get(run);
            Object time = timeBuilder.extract(gr);
            int timeIdx = timeCoord.getIndex(time);
            return new int[]{runIdx, timeIdx};
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record>
    implements CoordinateBuilder.TwoD<Grib2Record> {
        private final boolean isTimeInterval;
        private final Grib2Customizer cust;
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CoordinateRuntime.Builder2 runBuilder;
        private final Map<Object, CoordinateBuilderImpl<Grib2Record>> timeBuilders;

        public Builder2(boolean isTimeInterval, Grib2Customizer cust, CalendarPeriod timeUnit, int code) {
            this.isTimeInterval = isTimeInterval;
            this.cust = cust;
            this.timeUnit = timeUnit;
            this.code = code;
            this.runBuilder = new CoordinateRuntime.Builder2(timeUnit);
            this.timeBuilders = new HashMap<Object, CoordinateBuilderImpl<Grib2Record>>();
        }

        @Override
        public void addRecord(Grib2Record gr) {
            super.addRecord(gr);
            this.runBuilder.addRecord(gr);
            Time2D val = (Time2D)this.extract(gr);
            CoordinateBuilderImpl<Grib2Record> timeBuilder = this.timeBuilders.get(val.run);
            timeBuilder.addRecord(gr);
        }

        @Override
        public Object extract(Grib2Record gr) {
            Object time;
            Long run = (Long)this.runBuilder.extract(gr);
            CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(run);
            if (timeBuilder == null) {
                timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder2(this.cust, this.code, this.timeUnit, CalendarDate.of(run)) : new CoordinateTime.Builder2(this.code, this.timeUnit, CalendarDate.of(run));
                this.timeBuilders.put(run, timeBuilder);
            }
            if ((time = timeBuilder.extract((Grib2Record)gr)) instanceof Integer) {
                return new Time2D(run, (Integer)time, null);
            }
            return new Time2D(run, null, (TimeCoord.Tinv)time);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            CoordinateRuntime runCoord = (CoordinateRuntime)this.runBuilder.finish();
            ArrayList<Coordinate> times = new ArrayList<Coordinate>(runCoord.getSize());
            for (int idx = 0; idx < runCoord.getSize(); ++idx) {
                Long runtime = runCoord.getRuntime(idx);
                CoordinateBuilderImpl<Grib2Record> timeBuilder = this.timeBuilders.get(runtime);
                times.add(timeBuilder.finish());
            }
            ArrayList<Time2D> vals = new ArrayList<Time2D>(values.size());
            for (Object val : values) {
                vals.add((Time2D)val);
            }
            Collections.sort(vals);
            return new CoordinateTime2D(this.code, this.timeUnit, vals, runCoord, times);
        }

        @Override
        public void addAll(Coordinate coord) {
            super.addAll(coord);
            for (Object object : coord.getValues()) {
                Time2D val2D = (Time2D)object;
                this.runBuilder.add(val2D.run);
                CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(val2D.run);
                if (timeBuilder == null) {
                    timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder2(this.cust, this.code, this.timeUnit, val2D.getRefDate()) : new CoordinateTime.Builder2(this.code, this.timeUnit, val2D.getRefDate());
                    this.timeBuilders.put(val2D.run, timeBuilder);
                }
                timeBuilder.add(this.isTimeInterval ? val2D.tinv : val2D.time);
            }
        }

        @Override
        public int[] getCoordIndices(Grib2Record gr) {
            CoordinateTime2D coord2D = (CoordinateTime2D)this.coord;
            Long run = (Long)this.runBuilder.extract(gr);
            int runIdx = coord2D.runtime.getIndex(run);
            CoordinateTimeAbstract timeCoord = coord2D.getTimeCoordinate(runIdx);
            CoordinateBuilderImpl<Grib2Record> timeBuilder = this.timeBuilders.get(run);
            Object time = timeBuilder.extract(gr);
            int timeIdx = timeCoord.getIndex(time);
            return new int[]{runIdx, timeIdx};
        }
    }

    public static class Time2D
    implements Comparable<Time2D> {
        long run;
        Integer time;
        TimeCoord.Tinv tinv;

        public Time2D(CalendarDate run, Integer time, TimeCoord.Tinv tinv) {
            this.run = run.getMillis();
            this.time = time;
            this.tinv = tinv;
        }

        public Time2D(long run, Integer time, TimeCoord.Tinv tinv) {
            this.run = run;
            this.time = time;
            this.tinv = tinv;
        }

        public CalendarDate getRefDate() {
            return CalendarDate.of(this.run);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Time2D time2D = (Time2D)o;
            if (this.run != time2D.run) {
                return false;
            }
            if (this.time != null ? !this.time.equals(time2D.time) : time2D.time != null) {
                return false;
            }
            return !(this.tinv != null ? !this.tinv.equals(time2D.tinv) : time2D.tinv != null);
        }

        public int hashCode() {
            int result = (int)(this.run ^ this.run >>> 32);
            result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
            result = 31 * result + (this.tinv != null ? this.tinv.hashCode() : 0);
            return result;
        }

        public String toString() {
            if (this.time != null) {
                return this.time.toString();
            }
            return this.tinv.toString();
        }

        @Override
        public int compareTo(Time2D o) {
            int r = Long.compare(this.run, o.run);
            if (r == 0) {
                r = this.time != null ? this.time.compareTo(o.time) : this.tinv.compareTo(o.tinv);
            }
            return r;
        }
    }
}

