/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.zip.CRC32;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionGridDefinition {
    private final byte[] rawData;
    private final long startingPosition;
    private final int templateNumber;

    public Grib2SectionGridDefinition(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        int length = GribNumbers.int4(raf);
        int section = raf.read();
        if (section != 3) {
            throw new IllegalArgumentException("Not a GRIB-2 GDS section");
        }
        raf.skipBytes(7);
        this.templateNumber = GribNumbers.uint2(raf);
        this.rawData = new byte[length];
        raf.seek(this.startingPosition);
        raf.readFully(this.rawData);
    }

    public Grib2SectionGridDefinition(byte[] rawData) {
        this.rawData = rawData;
        this.templateNumber = GribNumbers.uint2(this.getOctet(13), this.getOctet(14));
        this.startingPosition = -1L;
    }

    public byte[] getRawBytes() {
        return this.rawData;
    }

    public long calcCRC() {
        CRC32 crc32 = new CRC32();
        crc32.update(this.rawData);
        return crc32.getValue();
    }

    public int getLength() {
        return this.rawData.length;
    }

    public long getOffset() {
        return this.startingPosition;
    }

    public int getSource() {
        return this.getOctet(6);
    }

    public int getNumberPoints() {
        return GribNumbers.int4(this.getOctet(7), this.getOctet(8), this.getOctet(9), this.getOctet(10));
    }

    public int getGDSTemplateNumber() {
        return this.templateNumber;
    }

    private int getOctet(int index) {
        return this.rawData[index - 1] & 0xFF;
    }

    public Grib2Gds getGDS() {
        return Grib2Gds.factory(this.templateNumber, this.rawData);
    }
}

