/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.grid.GridCF;
import ucar.nc2.iosp.grid.GridEnsembleCoord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class GridVariable {
    private static Logger log = LoggerFactory.getLogger(GridVariable.class);
    private final String filename;
    private final String name;
    public String vname;
    protected GridRecord firstRecord;
    protected GridTableLookup lookup;
    private GridHorizCoordSys hcs;
    protected GridTimeCoord tcs = null;
    protected GridEnsembleCoord ecs = null;
    protected GridVertCoord vc = null;
    private List<GridRecord> records = new ArrayList<GridRecord>();
    protected int nlevels;
    private int nens;
    protected int ntimes;
    protected GridRecord[] recordTracker;
    private boolean hasVert = false;
    private volatile int hashCode = 0;

    protected GridVariable(String filename, String name, GridHorizCoordSys hcs, GridTableLookup lookup) {
        this.filename = filename;
        this.name = name;
        this.hcs = hcs;
        this.lookup = lookup;
    }

    void addProduct(GridRecord record) {
        this.records.add(record);
        if (this.firstRecord == null) {
            this.firstRecord = record;
        }
    }

    List<GridRecord> getRecords() {
        return this.records;
    }

    GridRecord getFirstRecord() {
        return this.records.get(0);
    }

    GridHorizCoordSys getHorizCoordSys() {
        return this.hcs;
    }

    GridVertCoord getVertCoord() {
        return this.vc;
    }

    boolean hasVert() {
        return this.hasVert;
    }

    void setVarName(String vname) {
        this.vname = vname;
    }

    void setVertCoord(GridVertCoord vc) {
        this.vc = vc;
    }

    void setTimeCoord(GridTimeCoord tcs) {
        this.tcs = tcs;
    }

    void setEnsembleCoord(GridEnsembleCoord ecs) {
        this.ecs = ecs;
    }

    public int getNEnsembles() {
        return this.ecs == null ? 1 : this.ecs.getNEnsembles();
    }

    boolean hasEnsemble() {
        return this.ecs != null;
    }

    protected boolean isEnsemble() {
        return false;
    }

    int getVertNlevels() {
        return this.vc.getNLevels();
    }

    String getVertName() {
        return this.vc.getVariableName();
    }

    String getVertLevelName() {
        return this.vc.getLevelName();
    }

    boolean getVertIsUsed() {
        return this.vc.isVertDimensionUsed();
    }

    protected int getVertIndex(GridRecord p) {
        return this.vc.getIndex(p);
    }

    int getNTimes() {
        return this.tcs == null ? 1 : this.tcs.getNTimes();
    }

    protected void addExtraAttributes(GridParameter param, Variable v) {
        int icf = this.hcs.getGds().getInt("VectorComponentFlag");
        String flag = GridCF.VectorComponentFlag.of(icf);
        v.addAttribute(new Attribute("VectorComponentFlag", flag));
    }

    protected boolean trackRecords(int time, int level, GridRecord p, RandomAccessFile raf, boolean messSent) {
        int recno = time * this.nlevels + level;
        if (this.recordTracker[recno] == null) {
            this.recordTracker[recno] = p;
            if (log.isDebugEnabled()) {
                log.debug(" " + this.vc.getVariableName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevel1() + "," + p.getLevel2());
            }
        }
        return false;
    }

    Variable makeVariable(NetcdfFile ncfile, Group g, String useName, RandomAccessFile raf) {
        assert (this.records.size() > 0) : "no records for this variable";
        this.nlevels = this.getVertNlevels();
        this.ntimes = this.tcs.getNTimes();
        if (this.vname == null) {
            this.vname = useName = StringUtil2.replace(useName, ' ', "_");
        }
        Variable v = new Variable(ncfile, g, null, this.vname);
        v.setDataType(DataType.FLOAT);
        Formatter dims = new Formatter();
        if (this.hasEnsemble()) {
            dims.format("ens ", new Object[0]);
        }
        dims.format("%s ", this.tcs.getName());
        if (this.getVertIsUsed()) {
            dims.format("%s ", this.getVertName());
            this.hasVert = true;
        }
        if (this.hcs.isLatLon()) {
            dims.format("lat lon", new Object[0]);
        } else {
            dims.format("y x", new Object[0]);
        }
        v.setDimensions(dims.toString());
        GridParameter param = this.lookup.getParameter(this.firstRecord);
        if (param == null) {
            return null;
        }
        String unit = param.getUnit();
        if (unit == null) {
            unit = "";
        }
        v.addAttribute(new Attribute("units", unit));
        v.addAttribute(new Attribute("long_name", this.makeLongName()));
        v.addAttribute(new Attribute("missing_value", Float.valueOf(this.lookup.getFirstMissingValue())));
        if (!this.hcs.isLatLon()) {
            if (GridServiceProvider.addLatLon) {
                v.addAttribute(new Attribute("coordinates", "lat lon"));
            }
            v.addAttribute(new Attribute("grid_mapping", this.hcs.getGridName()));
        }
        this.addExtraAttributes(param, v);
        v.setSPobject(this);
        int nrecs = this.ntimes * this.nlevels;
        if (this.hasEnsemble()) {
            nrecs *= this.ecs.getNEnsembles();
        }
        this.recordTracker = new GridRecord[nrecs];
        if (log.isDebugEnabled()) {
            log.debug("Record Assignment for Variable " + this.getName());
        }
        boolean oneSent = false;
        for (GridRecord p : this.records) {
            int level = this.getVertIndex(p);
            if (!this.getVertIsUsed() && level > 0) {
                log.warn("inconsistent level encoding=" + level);
                level = 0;
            }
            int time = this.tcs.findIndex(p);
            if (level < 0) {
                log.warn("LEVEL NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n   " + this.getVertLevelName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevel1() + "," + p.getLevel2() + "\n");
                this.getVertIndex(p);
                continue;
            }
            if (time < 0) {
                log.warn("TIME NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n validTime= " + p.getValidTime() + "\n");
                this.tcs.findIndex(p);
                continue;
            }
            oneSent = this.trackRecords(time, level, p, raf, oneSent);
        }
        this.records.clear();
        return v;
    }

    public void showRecord(int recnum, Formatter f) {
        if (recnum < 0 || recnum > this.recordTracker.length - 1) {
            f.format("%d out of range [0,%d]%n", recnum, this.recordTracker.length - 1);
            return;
        }
        GridRecord gr = this.recordTracker[recnum];
        if (this.hasEnsemble()) {
            int ens = recnum / (this.nlevels * this.ntimes);
            int tmp = recnum - ens * (this.nlevels * this.ntimes);
            int time = tmp / this.nlevels;
            int level = tmp % this.nlevels;
            f.format("recnum=%d (record hash=%d) ens=%d time=%s(%d) level=%f(%d)%n", recnum, gr.hashCode(), ens, this.tcs.getCoord(time), time, this.vc.getCoord(level), level);
        } else {
            int time = recnum / this.nlevels;
            int level = recnum % this.nlevels;
            f.format("recnum=%d (record hash=%d) time=%s(%d) level=%f(%d)%n", recnum, gr.hashCode(), this.tcs.getCoord(time), time, this.vc.getCoord(level), level);
        }
    }

    public void showMissing(Formatter f) {
        int count = 0;
        int total = 0;
        f.format("  %s%n", this.name);
        for (int j = 0; j < this.nlevels; ++j) {
            f.format("   ", new Object[0]);
            for (int i = 0; i < this.ntimes; ++i) {
                boolean missing = this.recordTracker[i * this.nlevels + j] == null;
                f.format("%s", missing ? "-" : "X");
                if (missing) {
                    ++count;
                }
                ++total;
            }
            f.format("%n", new Object[0]);
        }
        f.format("  MISSING= %d / %d for %s%n", count, total, this.name);
    }

    public int showMissingSummary(Formatter f) {
        int count = 0;
        int total = this.recordTracker.length;
        for (int i = 0; i < total; ++i) {
            if (this.recordTracker[i] != null) continue;
            ++count;
        }
        f.format("  MISSING= %d / %d for %s%n", count, total, this.name);
        return count;
    }

    public GridRecord findRecord(int ens, int time, int level) {
        if (this.hasEnsemble()) {
            return this.recordTracker[ens * (this.ntimes * this.nlevels) + time * this.nlevels + level];
        }
        return this.recordTracker[time * this.nlevels + level];
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof GridVariable)) {
            return false;
        }
        return this.hashCode() == oo.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result += 37 * result + this.firstRecord.getLevelType1();
            result += 37 * result + this.hcs.getID().hashCode();
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.vname == null ? this.name : this.vname;
    }

    public String dump() {
        DateFormatter formatter = new DateFormatter();
        Formatter sbuff = new Formatter();
        sbuff.format("%s %d %n", this.name, this.records.size());
        for (GridRecord record : this.records) {
            sbuff.format(" level = %d %f", record.getLevelType1(), record.getLevel1());
            if (null != record.getValidTime()) {
                sbuff.format(" time = %s", formatter.toDateTimeString(record.getValidTime()));
            }
            sbuff.format("%n", new Object[0]);
        }
        return sbuff.toString();
    }

    protected String makeLongName() {
        Formatter f = new Formatter();
        GridParameter param = this.lookup.getParameter(this.firstRecord);
        if (param == null) {
            return null;
        }
        f.format("%s", param.getDescription());
        String levelName = this.makeLevelName(this.firstRecord, this.lookup);
        if (levelName.length() != 0) {
            f.format(" @ %s", levelName);
        }
        return f.toString();
    }

    public String makeLevelName(GridRecord gr, GridTableLookup lookup) {
        return lookup.getLevelName(gr);
    }

    public String makeIntervalName() {
        if (this.tcs.getConstantInterval() < 0) {
            return " Mixed Intervals";
        }
        return this.tcs.getConstantInterval() + " " + this.tcs.getTimeUnit() + " Intervals";
    }
}

