/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.Schema;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.Data;
import visad.DataImpl;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FormNode;
import visad.data.netcdf.NetCDF;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.QuantityDBManager;
import visad.data.netcdf.VariableFilter;
import visad.data.netcdf.in.NetcdfAdapter;
import visad.data.netcdf.in.Strategy;
import visad.data.netcdf.out.VisADAdapter;

public class Plain
extends NetCDF {
    private final QuantityDB quantityDB;
    private final boolean charToText;

    public Plain() throws VisADException {
        this(QuantityDBManager.instance(), false);
    }

    public Plain(boolean charToText) {
        this(QuantityDBManager.instance(), charToText);
    }

    public Plain(QuantityDB db) {
        this(db, false);
    }

    public Plain(QuantityDB db, boolean charToText) {
        super("Plain");
        this.quantityDB = db;
        this.charToText = charToText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(String path, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException, UnimplementedException {
        VisADAdapter adapter = new VisADAdapter(data);
        Schema schema = new Schema(adapter);
        NetcdfFile file = new NetcdfFile(path, replace, false, schema);
        try {
            VariableIterator iter = file.iterator();
            while (iter.hasNext()) {
                Variable outVar = iter.next();
                Variable inVar = adapter.get(outVar.getName());
                int rank = outVar.getRank();
                int[] origin = new int[rank];
                for (int i = 0; i < rank; ++i) {
                    origin[i] = 0;
                }
                outVar.copyin(origin, inVar);
            }
        }
        finally {
            file.close();
        }
    }

    public synchronized void add(String id, Data data, boolean replace) throws BadFormException {
    }

    public synchronized DataImpl open(String spec) throws BadFormException, IOException, VisADException {
        return new NetcdfAdapter(new NetcdfFile(spec, true), this.quantityDB, this.charToText).getData();
    }

    public synchronized DataImpl open(String spec, Strategy strategy) throws BadFormException, IOException, VisADException {
        return new NetcdfAdapter(new NetcdfFile(spec, true), this.quantityDB, this.charToText).getData(strategy);
    }

    public synchronized DataImpl openProxy(String path) throws BadFormException, IOException, VisADException {
        NetcdfFile file = new NetcdfFile(path, true);
        return new NetcdfAdapter(file, this.quantityDB, this.charToText).getProxy();
    }

    public synchronized DataImpl open(URL url) throws FileNotFoundException, IOException, VisADException {
        String file = url.getFile();
        int i = file.indexOf(63);
        String query = i == -1 ? null : (i == file.length() - 1 ? "" : file.substring(i + 1));
        TreeSet<String> names = new TreeSet<String>();
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, ",");
            while (st.hasMoreTokens()) {
                names.add(st.nextToken());
            }
        }
        NetcdfFile netcdf = new NetcdfFile(url);
        return new NetcdfAdapter(query == null ? netcdf : new VariableFilter(netcdf, names), this.quantityDB, this.charToText).getData();
    }

    public synchronized FormNode getForms(Data data) throws VisADException, RemoteException, IOException {
        Plain form;
        try {
            VisADAdapter adapter = new VisADAdapter(data);
            form = this;
        }
        catch (BadFormException e) {
            form = null;
        }
        return form;
    }

    public static void main(String[] args) throws Exception {
        DataImpl data;
        String outPath = "plain.nc";
        String inPath = args.length == 0 ? "test.nc" : args[0];
        Plain plain = new Plain(args.length > 1);
        System.out.println("Opening netCDF dataset \"" + inPath + "\"");
        try {
            URL url = new URL(inPath);
            data = plain.open(url);
        }
        catch (MalformedURLException e) {
            data = plain.open(inPath);
        }
        if (data == null) {
            System.out.println("No data");
        } else {
            System.out.println("data.getType().toString():\n" + data.getType());
            System.out.println("Writing netCDF dataset \"" + outPath + "\"");
            plain.save(outPath, data, true);
        }
    }
}

